/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils;

import com.google.cloud.bigquery.LegacySQLTypeName;
import java.util.Map;
import org.apache.beam.sdk.testutils.TestResult;
import org.apache.beam.sdk.testutils.publishing.InfluxDBPublisher;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedTestResult
implements TestResult {
    private final String testId;
    private final String timestamp;
    private final String metric;
    private final double value;
    private static final Map<String, String> schema = ImmutableMap.builder().put((Object)"test_id", (Object)LegacySQLTypeName.STRING.name()).put((Object)"timestamp", (Object)LegacySQLTypeName.TIMESTAMP.name()).put((Object)"metric", (Object)LegacySQLTypeName.STRING.name()).put((Object)"value", (Object)LegacySQLTypeName.FLOAT.name()).build();
    private static final Logger LOG = LoggerFactory.getLogger(NamedTestResult.class);

    private NamedTestResult(String testId, String timestamp, String metric, double value) {
        this.testId = testId;
        this.timestamp = timestamp;
        this.metric = metric;
        this.value = value;
    }

    public static NamedTestResult create(String testId, String timestamp, String metric, double value) {
        if (value < 0.0 && value != -1.0) {
            LOG.warn("Reset invalid NamedTestResult value {} to -1.0.", (Object)value);
            value = -1.0;
        }
        return new NamedTestResult(testId, timestamp, metric, value);
    }

    @Override
    public Map<String, Object> toMap() {
        return ImmutableMap.builder().putAll(this.tags()).putAll(this.fields()).put((Object)"timestamp", (Object)this.timestamp).build();
    }

    public static Map<String, String> getSchema() {
        return schema;
    }

    public String getMetric() {
        return this.metric;
    }

    public double getValue() {
        return this.value;
    }

    public Map<String, String> tags() {
        return ImmutableMap.of((Object)"test_id", (Object)this.testId, (Object)"metric", (Object)this.metric);
    }

    public Map<String, Number> fields() {
        return ImmutableMap.of((Object)"value", (Object)this.value);
    }

    public InfluxDBPublisher.DataPoint toInfluxDBDataPoint(String measurement) {
        return InfluxDBPublisher.dataPoint(measurement, this.tags(), this.fields(), null);
    }
}

