/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.publishing;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.testutils.TestResult;
import org.apache.beam.sdk.testutils.fakes.FakeBigQueryClient;
import org.apache.beam.sdk.testutils.publishing.BigQueryClient;
import org.apache.beam.sdk.testutils.publishing.BigQueryResultsPublisher;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryResultsPublisherTest {
    private static final String TABLE_NAME = "table";
    private BigQueryResultsPublisher publisher;
    private FakeBigQueryClient bigQueryClient;

    @Before
    public void setUp() {
        ImmutableMap schema = ImmutableMap.builder().put((Object)"timestamp", (Object)"timestamp").put((Object)"field1", (Object)"string").build();
        this.bigQueryClient = new FakeBigQueryClient();
        this.publisher = new BigQueryResultsPublisher((BigQueryClient)this.bigQueryClient, (Map)schema);
    }

    @Test
    public void testPublishRowWithTimestampField() {
        long now = 1000L;
        this.publisher.publish((TestResult)new SampleTestResult("a", "b"), TABLE_NAME, now);
        Map<String, ?> rowInTable = this.bigQueryClient.getRows(TABLE_NAME).get(0);
        Assert.assertEquals((long)2L, (long)rowInTable.entrySet().size());
        Assert.assertEquals((Object)1L, rowInTable.get("timestamp"));
        Assert.assertEquals((Object)"a", rowInTable.get("field1"));
    }

    @Test
    public void testPublishRowWithoutTimestamp() {
        this.publisher.publish((TestResult)new SampleTestResult("a", "b"), TABLE_NAME);
        Map<String, ?> rowInTable = this.bigQueryClient.getRows(TABLE_NAME).get(0);
        Assert.assertEquals((long)1L, (long)rowInTable.entrySet().size());
        Assert.assertEquals((Object)"a", rowInTable.get("field1"));
    }

    @Test
    public void testRowDoesntContainFieldsNotSpecifiedInSchema() {
        this.publisher.publish((TestResult)new SampleTestResult("a", "b"), TABLE_NAME);
        Map<String, ?> rowInTable = this.bigQueryClient.getRows(TABLE_NAME).get(0);
        Assert.assertNull(rowInTable.get("field2"));
    }

    @Test
    public void testPublishCollectionOfRecords() {
        List<SampleTestResult> results = Arrays.asList(new SampleTestResult("a", "b"), new SampleTestResult("a", "b"));
        this.publisher.publish(results, TABLE_NAME);
        Assert.assertEquals((long)2L, (long)this.bigQueryClient.getRows(TABLE_NAME).size());
    }

    private static class SampleTestResult
    implements TestResult {
        private String field1;
        private String field2;

        SampleTestResult(String field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
        }

        public Map<String, Object> toMap() {
            return ImmutableMap.builder().put((Object)"field1", (Object)this.field1).put((Object)"field2", (Object)this.field2).build();
        }
    }
}

