/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Instant;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WithTimestampsJava8Test
implements Serializable {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={ValidatesRunner.class})
    public void withTimestampsLambdaShouldApplyTimestamps() {
        String yearTwoThousand = "946684800000";
        PCollection timestamped = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)"1234", (Object[])new String[]{"0", Integer.toString(Integer.MAX_VALUE), "946684800000"}))).apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)input -> new Instant((Object)Long.valueOf(input))));
        PCollection timestampedVals = (PCollection)timestamped.apply((PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Instant>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output((Object)KV.of((Object)c.element(), (Object)c.timestamp()));
            }
        }));
        PAssert.that((PCollection)timestamped).containsInAnyOrder((Object[])new String[]{"946684800000", "0", "1234", Integer.toString(Integer.MAX_VALUE)});
        PAssert.that((PCollection)timestampedVals).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"0", (Object)new Instant(0L)), KV.of((Object)"1234", (Object)new Instant((Object)Long.valueOf("1234"))), KV.of((Object)Integer.toString(Integer.MAX_VALUE), (Object)new Instant(Integer.MAX_VALUE)), KV.of((Object)"946684800000", (Object)new Instant((Object)Long.valueOf("946684800000")))});
        this.p.run();
    }
}

