/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PipelineOptionsFactoryJava8Test {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDefaultMethodIgnoresDefaultImplementation() {
        OptionsWithDefaultMethod optsWithDefault = (OptionsWithDefaultMethod)PipelineOptionsFactory.as(OptionsWithDefaultMethod.class);
        Assert.assertThat((Object)optsWithDefault.getValue(), (Matcher)Matchers.nullValue());
        optsWithDefault.setValue(12.25);
        Assert.assertThat((Object)optsWithDefault.getValue(), (Matcher)Matchers.equalTo((Object)12.25));
    }

    @Test
    public void testDefaultMethodInExtendedClassIgnoresDefaultImplementation() {
        OptionsWithDefaultMethod extendedOptsWithDefault = (OptionsWithDefaultMethod)PipelineOptionsFactory.as(ExtendedOptionsWithDefault.class);
        Assert.assertThat((Object)extendedOptsWithDefault.getValue(), (Matcher)Matchers.nullValue());
        extendedOptsWithDefault.setValue(Double.NEGATIVE_INFINITY);
        Assert.assertThat((Object)extendedOptsWithDefault.getValue(), (Matcher)Matchers.equalTo((Object)Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testReturnTypeConflictThrows() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Method [getValue] has multiple definitions [public abstract java.lang.Integer org.apache.beam.sdk.options.PipelineOptionsFactoryJava8Test$SubtypeReturingOptions.getValue(), public abstract java.lang.Number org.apache.beam.sdk.options.PipelineOptionsFactoryJava8Test$Options.getValue()] with different return types for [org.apache.beam.sdk.options.PipelineOptionsFactoryJava8Test$SubtypeReturingOptions].");
        PipelineOptionsFactory.as(SubtypeReturingOptions.class);
    }

    private static interface SubtypeReturingOptions
    extends Options {
        @Override
        public Integer getValue();

        public void setValue(Integer var1);
    }

    private static interface Options
    extends PipelineOptions {
        public Number getValue();

        public void setValue(Number var1);
    }

    private static interface ExtendedOptionsWithDefault
    extends OptionsWithDefaultMethod {
    }

    private static interface OptionsWithDefaultMethod
    extends PipelineOptions {
        default public Number getValue() {
            return 1024;
        }

        public void setValue(Number var1);
    }
}

