/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.RunnableOnService;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WithKeysJava8Test {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={RunnableOnService.class})
    public void withLambdaAndTypeDescriptorShouldSucceed() {
        PCollection values = (PCollection)this.p.apply((PTransform)Create.of((Object)"1234", (Object[])new String[]{"3210", "0", "-12"}));
        PCollection kvs = (PCollection)values.apply((PTransform)WithKeys.of((SerializableFunction & Serializable)s -> Integer.valueOf(s)).withKeyType(TypeDescriptor.of(Integer.class)));
        PAssert.that((PCollection)kvs).containsInAnyOrder((Object[])new KV[]{KV.of((Object)1234, (Object)"1234"), KV.of((Object)0, (Object)"0"), KV.of((Object)-12, (Object)"-12"), KV.of((Object)3210, (Object)"3210")});
        this.p.run();
    }

    @Test
    public void withLambdaAndNoTypeDescriptorShouldThrow() {
        PCollection values = (PCollection)this.p.apply((PTransform)Create.of((Object)"1234", (Object[])new String[]{"3210", "0", "-12"}));
        values.apply("ApplyKeysWithWithKeys", (PTransform)WithKeys.of((SerializableFunction & Serializable)s -> Integer.valueOf(s)));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to return a default Coder for ApplyKeysWithWithKeys");
        this.thrown.expectMessage("No Coder has been manually specified");
        this.thrown.expectMessage(Matchers.containsString((String)"Building a Coder using a registered CoderFactory failed"));
        this.thrown.expectMessage(Matchers.containsString((String)"Building a Coder from the @DefaultCoder annotation failed"));
        this.thrown.expectMessage(Matchers.containsString((String)"Building a Coder from the fallback CoderProvider failed"));
        this.p.run();
    }
}

