/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MapElementsJava8Test
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testMapLambda() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)MapElements.via((SerializableFunction & Serializable)i -> i * 2).withOutputType((TypeDescriptor)new TypeDescriptor<Integer>(){}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{6, 2, 4});
        this.pipeline.run();
    }

    @Test
    public void testMapWrappedLambda() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Integer, Integer>((SerializableFunction & Serializable)i -> i * 2){}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{6, 2, 4});
        this.pipeline.run();
    }

    @Test
    public void testMapMethodReference() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)MapElements.via(new Doubler()::doubleIt).withOutputType((TypeDescriptor)new TypeDescriptor<Integer>(){}));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{6, 2, 4});
        this.pipeline.run();
    }

    private static class Doubler
    implements Serializable {
        private Doubler() {
        }

        public int doubleIt(int val) {
            return val * 2;
        }
    }
}

