/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Distinct;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DistinctJava8Test {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void withLambdaRepresentativeValuesFnAndTypeDescriptorShouldApplyFn() {
        HashMultimap predupedContents = HashMultimap.create();
        predupedContents.put((Object)3, (Object)"foo");
        predupedContents.put((Object)4, (Object)"foos");
        predupedContents.put((Object)6, (Object)"barbaz");
        predupedContents.put((Object)6, (Object)"bazbar");
        PCollection dupes = (PCollection)this.p.apply((PTransform)Create.of((Object)"foo", (Object[])new String[]{"foos", "barbaz", "barbaz", "bazbar", "foo"}));
        PCollection deduped = (PCollection)dupes.apply((PTransform)Distinct.withRepresentativeValueFn((SerializableFunction & Serializable)s -> s.length()).withRepresentativeType(TypeDescriptor.of(Integer.class)));
        PAssert.that((PCollection)deduped).satisfies(arg_0 -> DistinctJava8Test.lambda$withLambdaRepresentativeValuesFnAndTypeDescriptorShouldApplyFn$1fd09e4b$1((Multimap)predupedContents, arg_0));
        this.p.run();
    }

    @Test
    public void withLambdaRepresentativeValuesFnNoTypeDescriptorShouldThrow() {
        HashMultimap predupedContents = HashMultimap.create();
        predupedContents.put((Object)3, (Object)"foo");
        predupedContents.put((Object)4, (Object)"foos");
        predupedContents.put((Object)6, (Object)"barbaz");
        predupedContents.put((Object)6, (Object)"bazbar");
        PCollection dupes = (PCollection)this.p.apply((PTransform)Create.of((Object)"foo", (Object[])new String[]{"foos", "barbaz", "barbaz", "bazbar", "foo"}));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to return a default Coder for RemoveRepresentativeDupes");
        this.thrown.expectMessage("No Coder has been manually specified");
        this.thrown.expectMessage(Matchers.containsString((String)"Building a Coder using a registered CoderFactory failed"));
        this.thrown.expectMessage(Matchers.containsString((String)"Building a Coder from the @DefaultCoder annotation failed"));
        this.thrown.expectMessage(Matchers.containsString((String)"Building a Coder from the fallback CoderProvider failed"));
        dupes.apply("RemoveRepresentativeDupes", (PTransform)Distinct.withRepresentativeValueFn((SerializableFunction & Serializable)s -> s.length()));
    }

    private static /* synthetic */ Void lambda$withLambdaRepresentativeValuesFnAndTypeDescriptorShouldApplyFn$1fd09e4b$1(Multimap predupedContents, Iterable strs) {
        HashSet<Integer> seenLengths = new HashSet<Integer>();
        for (String s : strs) {
            Assert.assertThat((Object)predupedContents.values(), (Matcher)Matchers.hasItem((Object)s));
            Assert.assertThat(seenLengths, (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new Integer[]{s.length()})));
            seenLengths.add(s.length());
        }
        return null;
    }
}

