/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.xml.XmlIO;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XmlIOTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestPipeline mainPipeline = TestPipeline.create();
    @Rule
    public TestPipeline readPipeline = TestPipeline.create();
    private static final List<Bird> BIRDS = Lists.newArrayList((Object[])new Bird[]{new Bird("bemused", "robin"), new Bird("evasive", "goose"), new Bird("br\u00e9che", "pin\u00e7on")});

    @Test
    public void testXmlWriteThenReadViaSinkAndReadFilesUTF8() {
        this.testWriteThenRead(Method.SINK_AND_READ_FILES, BIRDS, StandardCharsets.UTF_8);
    }

    @Test
    public void testXmlWriteThenReadViaSinkAndReadFilesISO8859() {
        this.testWriteThenRead(Method.SINK_AND_READ_FILES, BIRDS, StandardCharsets.ISO_8859_1);
    }

    @Test
    public void testXmlWriteThenReadViaWriteAndReadUTF8() {
        this.testWriteThenRead(Method.WRITE_AND_READ, BIRDS, StandardCharsets.UTF_8);
    }

    @Test
    public void testXmlWriteThenReadViaWriteAndReadISO8859() {
        this.testWriteThenRead(Method.WRITE_AND_READ, BIRDS, StandardCharsets.ISO_8859_1);
    }

    private void testWriteThenRead(Method method, List<Bird> birds, Charset charset) {
        switch (method) {
            case SINK_AND_READ_FILES: {
                PCollection writeThenRead = (PCollection)((PCollection)((PCollection)((PCollection)((WriteFilesResult)((PCollection)this.mainPipeline.apply((PTransform)Create.of(birds))).apply((PTransform)FileIO.write().via((FileIO.Sink)XmlIO.sink(Bird.class).withRootElement("birds").withCharset(charset)).to(this.tmpFolder.getRoot().getAbsolutePath()).withPrefix("birds").withSuffix(".xml"))).getPerDestinationOutputFilenames().apply((PTransform)Values.create())).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply((PTransform)XmlIO.readFiles().withRecordClass(Bird.class).withRootElement("birds").withRecordElement("bird").withCharset(charset));
                PAssert.that((PCollection)writeThenRead).containsInAnyOrder(birds);
                this.mainPipeline.run();
                break;
            }
            case WRITE_AND_READ: {
                ((PCollection)this.mainPipeline.apply((PTransform)Create.of(birds))).apply((PTransform)XmlIO.write().to(new File(this.tmpFolder.getRoot(), "birds").getAbsolutePath()).withRecordClass(Bird.class).withRootElement("birds").withCharset(charset));
                this.mainPipeline.run();
                PCollection readBack = (PCollection)this.readPipeline.apply((PTransform)XmlIO.read().from(this.readPipeline.newProvider((Object)(new File(this.tmpFolder.getRoot(), "birds").getAbsolutePath() + "*"))).withRecordClass(Bird.class).withRootElement("birds").withRecordElement("bird").withCharset(charset));
                PAssert.that((PCollection)readBack).containsInAnyOrder(birds);
                this.readPipeline.run();
            }
        }
    }

    @Test
    public void testWriteThenReadLarger() {
        ArrayList birds = Lists.newArrayList();
        for (int i = 0; i < 100; ++i) {
            birds.add(new Bird("Testing", "Bird number " + i));
        }
        ((PCollection)this.mainPipeline.apply((PTransform)Create.of((Iterable)birds))).apply((PTransform)FileIO.write().via((FileIO.Sink)XmlIO.sink(Bird.class).withRootElement("birds")).to(this.tmpFolder.getRoot().getAbsolutePath()).withPrefix("birds").withSuffix(".xml").withNumShards(1));
        this.mainPipeline.run();
        PCollection readBack = (PCollection)this.readPipeline.apply((PTransform)XmlIO.read().from(new File(this.tmpFolder.getRoot(), "birds").getAbsolutePath() + "*").withRecordClass(Bird.class).withRootElement("birds").withRecordElement("bird").withMinBundleSize(100L));
        PAssert.that((PCollection)readBack).containsInAnyOrder((Iterable)birds);
        this.readPipeline.run();
    }

    @Test
    public void testDisplayData() {
        DisplayData displayData = DisplayData.from((HasDisplayData)XmlIO.read().from("foo.xml").withRootElement("bird").withRecordElement("cat").withMinBundleSize(1234L).withRecordClass(Integer.class));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"filePattern", (String)"foo.xml"));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"rootElement", (String)"bird"));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"recordElement", (String)"cat"));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"recordClass", Integer.class));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"minBundleSize", (long)1234L));
    }

    @Test
    public void testWriteDisplayData() {
        XmlIO.Write write = XmlIO.write().withRootElement("bird").withRecordClass(Integer.class);
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"rootElement", (String)"bird"));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"recordClass", Integer.class));
    }

    @XmlRootElement(name="bird")
    @XmlType(propOrder={"name", "adjective"})
    private static final class Bird
    implements Serializable {
        private String name;
        private String adjective;

        @XmlElement(name="species")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAdjective() {
            return this.adjective;
        }

        public void setAdjective(String adjective) {
            this.adjective = adjective;
        }

        public Bird() {
        }

        public Bird(String adjective, String name) {
            this.adjective = adjective;
            this.name = name;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bird bird = (Bird)o;
            if (!this.name.equals(bird.name)) {
                return false;
            }
            return this.adjective.equals(bird.adjective);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.adjective.hashCode();
            return result;
        }

        public String toString() {
            return String.format("Bird: %s, %s", this.name, this.adjective);
        }
    }

    static enum Method {
        SINK_AND_READ_FILES,
        WRITE_AND_READ;

    }
}

