/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.xml.JAXBCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JAXBCoderTest {
    @Test
    public void testEncodeDecodeOuter() throws Exception {
        JAXBCoder coder = JAXBCoder.of(TestType.class);
        byte[] encoded = CoderUtils.encodeToByteArray((Coder)coder, (Object)new TestType("abc", 9999));
        Assert.assertEquals((Object)new TestType("abc", 9999), (Object)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])encoded));
    }

    @Test
    public void testEncodeDecodeAfterClone() throws Exception {
        JAXBCoder coder = (JAXBCoder)SerializableUtils.clone((Serializable)JAXBCoder.of(TestType.class));
        byte[] encoded = CoderUtils.encodeToByteArray((Coder)coder, (Object)new TestType("abc", 9999));
        Assert.assertEquals((Object)new TestType("abc", 9999), (Object)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])encoded));
    }

    @Test
    public void testEncodeDecodeNested() throws Exception {
        JAXBCoder jaxbCoder = JAXBCoder.of(TestType.class);
        TestCoder nesting = new TestCoder((JAXBCoder<TestType>)jaxbCoder);
        byte[] encoded = CoderUtils.encodeToByteArray((Coder)nesting, (Object)new TestType("abc", 9999));
        Assert.assertEquals((Object)new TestType("abc", 9999), (Object)CoderUtils.decodeFromByteArray((Coder)nesting, (byte[])encoded));
    }

    @Test
    public void testEncodeDecodeMultithreaded() throws Throwable {
        JAXBCoder coder = JAXBCoder.of(TestType.class);
        int numThreads = 100;
        CountDownLatch ready = new CountDownLatch(numThreads);
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch done = new CountDownLatch(numThreads);
        AtomicReference thrown = new AtomicReference();
        ExecutorService executor = Executors.newCachedThreadPool();
        int i = 0;
        while (i < numThreads) {
            TestType elem = new TestType("abc", i);
            int index = i++;
            executor.execute(() -> {
                ready.countDown();
                try {
                    start.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    byte[] encoded = CoderUtils.encodeToByteArray((Coder)coder, (Object)elem);
                    Assert.assertEquals((Object)new TestType("abc", index), (Object)CoderUtils.decodeFromByteArray((Coder)coder, (byte[])encoded));
                }
                catch (Throwable e) {
                    thrown.compareAndSet(null, e);
                }
                done.countDown();
            });
        }
        ready.await();
        start.countDown();
        done.await();
        Throwable actuallyThrown = (Throwable)thrown.get();
        if (actuallyThrown != null) {
            throw actuallyThrown;
        }
    }

    @Test
    public void testEncodable() {
        CoderProperties.coderSerializable((Coder)JAXBCoder.of(TestType.class));
    }

    @Test
    public void testEncodedTypeDescriptor() {
        Assert.assertThat((Object)JAXBCoder.of(TestType.class).getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(TestType.class)));
    }

    private static class TestCoder
    extends StructuredCoder<TestType> {
        private final JAXBCoder<TestType> jaxbCoder;

        TestCoder(JAXBCoder<TestType> jaxbCoder) {
            this.jaxbCoder = jaxbCoder;
        }

        public void encode(TestType value, OutputStream outStream) throws IOException {
            this.encode(value, outStream, Coder.Context.NESTED);
        }

        public void encode(TestType value, OutputStream outStream, Coder.Context context) throws IOException {
            VarIntCoder.of().encode(Integer.valueOf(3), outStream);
            this.jaxbCoder.encode((Object)value, outStream);
            VarLongCoder.of().encode((Object)22L, outStream, context);
        }

        public TestType decode(InputStream inStream) throws IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        public TestType decode(InputStream inStream, Coder.Context context) throws IOException {
            VarIntCoder.of().decode(inStream);
            TestType result = (TestType)this.jaxbCoder.decode(inStream);
            VarLongCoder.of().decode(inStream, context);
            return result;
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return ImmutableList.of(this.jaxbCoder);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.jaxbCoder.verifyDeterministic();
        }
    }

    @XmlRootElement
    static class TestType {
        private String testString = null;
        private int testInt;

        TestType() {
        }

        TestType(String testString, int testInt) {
            this.testString = testString;
            this.testInt = testInt;
        }

        public String getTestString() {
            return this.testString;
        }

        public void setTestString(String testString) {
            this.testString = testString;
        }

        public int getTestInt() {
            return this.testInt;
        }

        public void setTestInt(int testInt) {
            this.testInt = testInt;
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + (this.testString == null ? 0 : this.testString.hashCode());
            hashCode = 31 * hashCode + this.testInt;
            return hashCode;
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof TestType)) {
                return false;
            }
            TestType other = (TestType)obj;
            return (this.testString == null || this.testString.equals(other.testString)) && this.testInt == other.testInt;
        }
    }
}

