/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.xml.XmlIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XmlSourceTest {
    @Rule
    public TestPipeline p = TestPipeline.create();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private String tinyXML = "<trains><train><name>Thomas</name></train><train><name>Henry</name></train><train><name>James</name></train></trains>";
    private String xmlWithMultiByteElementName = "<\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba\u0db1\u0dca><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><name>Thomas</name></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><name>Henry</name></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><name>James</name></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba\u0db1\u0dca>";
    private String xmlWithMultiByteChars = "<trains><train><name>Thomas\u00a5</name></train><train><name>Hen\u00b6ry</name></train><train><name>Jam\u00dfes</name></train></trains>";
    private String trainXML = "<trains><train><name>Thomas</name><number>1</number><color>blue</color></train><train><name>Henry</name><number>3</number><color>green</color></train><train><name>Toby</name><number>7</number><color>brown</color></train><train><name>Gordon</name><number>4</number><color>blue</color></train><train><name>Emily</name><number>-1</number><color>red</color></train><train><name>Percy</name><number>6</number><color>green</color></train></trains>";
    private String trainXMLWithEmptyTags = "<trains><train/><train><name>Thomas</name><number>1</number><color>blue</color></train><train><name>Henry</name><number>3</number><color>green</color></train><train/><train><name>Toby</name><number>7</number><color>brown</color></train><train><name>Gordon</name><number>4</number><color>blue</color></train><train><name>Emily</name><number>-1</number><color>red</color></train><train><name>Percy</name><number>6</number><color>green</color></train></trains>";
    private String trainXMLWithAttributes = "<trains><train size=\"small\"><name>Thomas</name><number>1</number><color>blue</color></train><train size=\"big\"><name>Henry</name><number>3</number><color>green</color></train><train size=\"small\"><name>Toby</name><number>7</number><color>brown</color></train><train size=\"big\"><name>Gordon</name><number>4</number><color>blue</color></train><train size=\"small\"><name>Emily</name><number>-1</number><color>red</color></train><train size=\"small\"><name>Percy</name><number>6</number><color>green</color></train></trains>";
    private String trainXMLWithSpaces = "<trains><train><name>Thomas   </name>   <number>1</number><color>blue</color></train><train><name>Henry</name><number>3</number><color>green</color></train>\n<train><name>Toby</name><number>7</number><color>  brown  </color></train>  <train><name>Gordon</name>   <number>4</number><color>blue</color>\n</train>\t<train><name>Emily</name><number>-1</number>\t<color>red</color></train><train>\n<name>Percy</name>   <number>6  </number>   <color>green</color></train></trains>";
    private String trainXMLWithAllFeaturesMultiByte = "<\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba\u0db1\u0dca><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba/><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba size=\"small\"><name> Thomas\u00a5</name><number>1</number><color>blue</color></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba size=\"big\"><name>He nry</name><number>3</number><color>green</color></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba size=\"small\"><name>Toby  </name><number>7</number><color>br\u00b6own</color></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba/><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba size=\"big\"><name>Gordon</name><number>4</number><color> blue</color></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba size=\"small\"><name>Emily</name><number>-1</number><color>red</color></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba><\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba size=\"small\"><name>Percy</name><number>6</number><color>green</color></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba></\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba\u0db1\u0dca>";
    private String trainXMLWithAllFeaturesSingleByte = "<trains><train/><train size=\"small\"><name> Thomas</name><number>1</number><color>blue</color></train><train size=\"big\"><name>He nry</name><number>3</number><color>green</color></train><train size=\"small\"><name>Toby  </name><number>7</number><color>brown</color></train><train/><train size=\"big\"><name>Gordon</name><number>4</number><color> blue</color></train><train size=\"small\"><name>Emily</name><number>-1</number><color>red</color></train><train size=\"small\"><name>Percy</name><number>6</number><color>green</color></train></trains>";
    private String trainXMLWithISO88591 = "<trains><train size=\"small\"><name>C\u00e9dric</name><number>7</number><color>blue</color></train></trains>";

    private List<Train> generateRandomTrainList(int size) {
        String[] names = new String[]{"Thomas", "Henry", "Gordon", "Emily", "Toby", "Percy", "Mavis", "Edward", "Bertie", "Harold", "Hiro", "Terence", "Salty", "Trevor"};
        int[] numbers = new int[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        String[] colors = new String[]{"red", "blue", "green", "orange", "brown", "black", "white"};
        String[] sizes = new String[]{"small", "medium", "big"};
        Random random = new Random(System.currentTimeMillis());
        ArrayList<Train> trains = new ArrayList<Train>();
        for (int i = 0; i < size; ++i) {
            trains.add(new Train(names[random.nextInt(names.length - 1)], numbers[random.nextInt(numbers.length - 1)], colors[random.nextInt(colors.length - 1)], sizes[random.nextInt(sizes.length - 1)]));
        }
        return trains;
    }

    private String trainToXMLElement(Train train) {
        return "<train size=\"" + train.size + "\"><name>" + train.name + "</name><number>" + train.number + "</number><color>" + train.color + "</color></train>";
    }

    private File createRandomTrainXML(String fileName, List<Train> trains) throws IOException {
        File file = this.tempFolder.newFile(fileName);
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write("<trains>");
            writer.newLine();
            for (Train train : trains) {
                String str = this.trainToXMLElement(train);
                writer.write(str);
                writer.newLine();
            }
            writer.write("</trains>");
            writer.newLine();
        }
        return file;
    }

    private <T> List<T> readEverythingFromReader(Source.Reader<T> reader) throws IOException {
        ArrayList<Object> results = new ArrayList<Object>();
        boolean available = reader.start();
        while (available) {
            Object train = reader.getCurrent();
            results.add(train);
            available = reader.advance();
        }
        return results;
    }

    @Test
    public void testReadXMLTiny() throws IOException {
        File file = this.tempFolder.newFile("trainXMLTiny");
        Files.write(file.toPath(), this.tinyXML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(1024L).createSource();
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas", -1, null, null), (Object)new Train("Henry", -1, null, null), (Object)new Train("James", -1, null, null));
        Assert.assertThat(this.trainsToStrings((List<Train>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    public void testReadXMLWithMultiByteChars() throws IOException {
        File file = this.tempFolder.newFile("trainXMLTiny");
        Files.write(file.toPath(), this.xmlWithMultiByteChars.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(1024L).createSource();
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas\u00a5", -1, null, null), (Object)new Train("Hen\u00b6ry", -1, null, null), (Object)new Train("Jam\u00dfes", -1, null, null));
        Assert.assertThat(this.trainsToStrings((List<Train>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    @Ignore(value="Multi-byte characters in XML are not supported because the parser currently does not correctly report byte offsets")
    public void testReadXMLWithMultiByteElementName() throws IOException {
        File file = this.tempFolder.newFile("trainXMLTiny");
        Files.write(file.toPath(), this.xmlWithMultiByteElementName.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba\u0db1\u0dca").withRecordElement("\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba").withRecordClass(Train.class).withMinBundleSize(1024L).createSource();
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas", -1, null, null), (Object)new Train("Henry", -1, null, null), (Object)new Train("James", -1, null, null));
        Assert.assertThat(this.trainsToStrings((List<Train>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    public void testSplitWithEmptyBundleAtEnd() throws Exception {
        File file = this.tempFolder.newFile("trainXMLTiny");
        Files.write(file.toPath(), this.tinyXML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(10L).createSource();
        List splits = source.split(50L, null);
        Assert.assertTrue((splits.size() > 2 ? 1 : 0) != 0);
        ArrayList<Train> results = new ArrayList<Train>();
        for (BoundedSource split : splits) {
            results.addAll(this.readEverythingFromReader((Source.Reader)split.createReader(null)));
        }
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas", -1, null, null), (Object)new Train("Henry", -1, null, null), (Object)new Train("James", -1, null, null));
        Assert.assertThat(this.trainsToStrings((List<Train>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(results).toArray()));
    }

    List<String> trainsToStrings(List<Train> input) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Train data : input) {
            strings.add(((Object)data).toString());
        }
        return strings;
    }

    List<String> tinyTrainsToStrings(List<TinyTrain> input) {
        ArrayList<String> strings = new ArrayList<String>();
        for (TinyTrain data : input) {
            strings.add(((Object)data).toString());
        }
        return strings;
    }

    @Test
    public void testReadXMLSmall() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(1024L).createSource();
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas", 1, "blue", null), (Object)new Train("Henry", 3, "green", null), (Object)new Train("Toby", 7, "brown", null), (Object)new Train("Gordon", 4, "blue", null), (Object)new Train("Emily", -1, "red", null), (Object)new Train("Percy", 6, "green", null));
        Assert.assertThat(this.trainsToStrings((List<Train>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    public void testReadXMLIncorrectRootElement() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("something").withRecordElement("train").withRecordClass(Train.class).createSource();
        this.exception.expectMessage("Unexpected close tag </trains>; expected </something>.");
        this.readEverythingFromReader((Source.Reader)source.createReader(null));
    }

    @Test
    public void testReadXMLIncorrectRecordElement() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("something").withRecordClass(Train.class).createSource();
        Assert.assertEquals(this.readEverythingFromReader((Source.Reader)source.createReader(null)), new ArrayList());
    }

    @Test
    public void testReadXMLInvalidRecordClassWithCustomEventHandler() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        ValidationEventHandler validationEventHandler = event -> {
            throw new RuntimeException("MyCustomValidationEventHandler failure mesage");
        };
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(WrongTrainType.class).withValidationEventHandler(validationEventHandler).createSource();
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("MyCustomValidationEventHandler failure mesage");
        try (BoundedSource.BoundedReader reader = source.createReader(null);){
            ArrayList<WrongTrainType> results = new ArrayList<WrongTrainType>();
            boolean available = reader.start();
            while (available) {
                WrongTrainType train = (WrongTrainType)reader.getCurrent();
                results.add(train);
                available = reader.advance();
            }
        }
    }

    @Test
    public void testReadXmlWithAdditionalFieldsShouldNotThrowException() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(TinyTrain.class).createSource();
        ImmutableList expectedResults = ImmutableList.of((Object)new TinyTrain("Thomas"), (Object)new TinyTrain("Henry"), (Object)new TinyTrain("Toby"), (Object)new TinyTrain("Gordon"), (Object)new TinyTrain("Emily"), (Object)new TinyTrain("Percy"));
        Assert.assertThat(this.tinyTrainsToStrings((List<TinyTrain>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.tinyTrainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    public void testReadXMLNoBundleSize() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).createSource();
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas", 1, "blue", null), (Object)new Train("Henry", 3, "green", null), (Object)new Train("Toby", 7, "brown", null), (Object)new Train("Gordon", 4, "blue", null), (Object)new Train("Emily", -1, "red", null), (Object)new Train("Percy", 6, "green", null));
        Assert.assertThat(this.trainsToStrings((List<Train>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    public void testReadXMLWithEmptyTags() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXMLWithEmptyTags.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(1024L).createSource();
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas", 1, "blue", null), (Object)new Train("Henry", 3, "green", null), (Object)new Train("Toby", 7, "brown", null), (Object)new Train("Gordon", 4, "blue", null), (Object)new Train("Emily", -1, "red", null), (Object)new Train("Percy", 6, "green", null), (Object)new Train(), (Object)new Train());
        Assert.assertThat(this.trainsToStrings((List<Train>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    public void testReadXMLWithCharset() throws IOException {
        File file = this.tempFolder.newFile("trainXMLISO88591");
        Files.write(file.toPath(), this.trainXMLWithISO88591.getBytes(StandardCharsets.ISO_8859_1), new OpenOption[0]);
        PCollection output = (PCollection)this.p.apply("ReadFileData", (PTransform)XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(1024L).withCharset(StandardCharsets.ISO_8859_1));
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("C\u00e9dric", 7, "blue", "small"));
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)expectedResults);
        this.p.run();
    }

    @Test
    public void testReadXMLSmallPipeline() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        PCollection output = (PCollection)this.p.apply("ReadFileData", (PTransform)XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(1024L));
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas", 1, "blue", null), (Object)new Train("Henry", 3, "green", null), (Object)new Train("Toby", 7, "brown", null), (Object)new Train("Gordon", 4, "blue", null), (Object)new Train("Emily", -1, "red", null), (Object)new Train("Percy", 6, "green", null));
        PAssert.that((PCollection)output).containsInAnyOrder((Iterable)expectedResults);
        this.p.run();
    }

    @Test
    public void testReadXMLWithAttributes() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXMLWithAttributes.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(1024L).createSource();
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas", 1, "blue", "small"), (Object)new Train("Henry", 3, "green", "big"), (Object)new Train("Toby", 7, "brown", "small"), (Object)new Train("Gordon", 4, "blue", "big"), (Object)new Train("Emily", -1, "red", "small"), (Object)new Train("Percy", 6, "green", "small"));
        Assert.assertThat(this.trainsToStrings((List<Train>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    public void testReadXMLWithWhitespaces() throws IOException {
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXMLWithSpaces.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(1024L).createSource();
        ImmutableList expectedResults = ImmutableList.of((Object)new Train("Thomas   ", 1, "blue", null), (Object)new Train("Henry", 3, "green", null), (Object)new Train("Toby", 7, "  brown  ", null), (Object)new Train("Gordon", 4, "blue", null), (Object)new Train("Emily", -1, "red", null), (Object)new Train("Percy", 6, "green", null));
        Assert.assertThat(this.trainsToStrings((List<Train>)expectedResults), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    public void testReadXMLLarge() throws IOException {
        String fileName = "temp.xml";
        List<Train> trains = this.generateRandomTrainList(100);
        File file = this.createRandomTrainXML(fileName, trains);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(1024L).createSource();
        Assert.assertThat(this.trainsToStrings(trains), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(this.readEverythingFromReader((Source.Reader)source.createReader(null))).toArray()));
    }

    @Test
    public void testSplitWithEmptyBundles() throws Exception {
        String fileName = "temp.xml";
        List<Train> trains = this.generateRandomTrainList(10);
        File file = this.createRandomTrainXML(fileName, trains);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(10L).createSource();
        List splits = source.split(100L, null);
        Assert.assertTrue((splits.size() > 2 ? 1 : 0) != 0);
        ArrayList<Train> results = new ArrayList<Train>();
        for (BoundedSource split : splits) {
            results.addAll(this.readEverythingFromReader((Source.Reader)split.createReader(null)));
        }
        Assert.assertThat(this.trainsToStrings(trains), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(results).toArray()));
    }

    @Test
    public void testXMLWithSplits() throws Exception {
        String fileName = "temp.xml";
        List<Train> trains = this.generateRandomTrainList(100);
        File file = this.createRandomTrainXML(fileName, trains);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(10L).createSource();
        List splits = source.split(256L, null);
        Assert.assertTrue((splits.size() > 2 ? 1 : 0) != 0);
        ArrayList<Train> results = new ArrayList<Train>();
        for (BoundedSource split : splits) {
            results.addAll(this.readEverythingFromReader((Source.Reader)split.createReader(null)));
        }
        Assert.assertThat(this.trainsToStrings(trains), (Matcher)Matchers.containsInAnyOrder((Object[])this.trainsToStrings(results).toArray()));
    }

    @Test
    public void testSplitAtFraction() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        String fileName = "temp.xml";
        List<Train> trains = this.generateRandomTrainList(100);
        File file = this.createRandomTrainXML(fileName, trains);
        BoundedSource fileSource = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).withMinBundleSize(10L).createSource();
        List splits = fileSource.split(file.length() / 3L, null);
        for (BoundedSource splitSource : splits) {
            int numItems = this.readEverythingFromReader((Source.Reader)splitSource.createReader(null)).size();
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)splitSource, (int)0, (double)0.7, (PipelineOptions)options);
            SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)splitSource, (int)1, (double)0.7, (PipelineOptions)options);
            SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)splitSource, (int)15, (double)0.7, (PipelineOptions)options);
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)splitSource, (int)0, (double)0.0, (PipelineOptions)options);
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)splitSource, (int)20, (double)0.3, (PipelineOptions)options);
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)splitSource, (int)numItems, (double)1.0, (PipelineOptions)options);
            SourceTestUtils.assertSplitAtFractionFails((BoundedSource)splitSource, (int)numItems, (double)0.9, (PipelineOptions)options);
            SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)splitSource, (int)(numItems - 1), (double)0.999, (PipelineOptions)options);
        }
    }

    @Test
    public void testSplitAtFractionExhaustiveSingleByte() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXMLWithAllFeaturesSingleByte.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("trains").withRecordElement("train").withRecordClass(Train.class).createSource();
        SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)source, (PipelineOptions)options);
    }

    @Test
    @Ignore(value="Multi-byte characters in XML are not supported because the parser currently does not correctly report byte offsets")
    public void testSplitAtFractionExhaustiveMultiByte() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        File file = this.tempFolder.newFile("trainXMLSmall");
        Files.write(file.toPath(), this.trainXMLWithAllFeaturesMultiByte.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        BoundedSource source = XmlIO.read().from(file.toPath().toString()).withRootElement("\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba\u0db1\u0dca").withRecordElement("\u0daf\u0dd4\u0db8\u0dca\u0dbb\u0dd2\u0dba").withRecordClass(Train.class).createSource();
        SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)source, (PipelineOptions)options);
    }

    @XmlRootElement
    private static class WrongTrainType {
        public String something;

        private WrongTrainType() {
        }
    }

    @XmlRootElement
    static class Train {
        public static final int TRAIN_NUMBER_UNDEFINED = -1;
        public String name = null;
        public String color = null;
        public int number = -1;
        @XmlAttribute(name="size")
        public String size = null;

        public Train() {
        }

        public Train(String name, int number, String color, String size) {
            this.name = name;
            this.number = number;
            this.color = color;
            this.size = size;
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.number;
            hashCode = 31 * hashCode + (this.color == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.size == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Train)) {
                return false;
            }
            Train other = (Train)obj;
            return !(this.name != null && !this.name.equals(other.name) || this.number != other.number || this.color != null && !this.color.equals(other.color) || this.size != null && !this.size.equals(other.size));
        }

        public String toString() {
            String str = "Train[";
            boolean first = true;
            if (this.name != null) {
                str = str + "name=" + this.name;
                first = false;
            }
            if (this.number != Integer.MIN_VALUE) {
                if (!first) {
                    str = str + ",";
                }
                str = str + "number=" + this.number;
                first = false;
            }
            if (this.color != null) {
                if (!first) {
                    str = str + ",";
                }
                str = str + "color=" + this.color;
                first = false;
            }
            if (this.size != null) {
                if (!first) {
                    str = str + ",";
                }
                str = str + "size=" + this.size;
            }
            str = str + "]";
            return str;
        }
    }

    @XmlRootElement
    static class TinyTrain {
        public String name = null;

        TinyTrain(String name) {
            this.name = name;
        }

        public TinyTrain() {
        }

        public String toString() {
            String str = "Train[";
            if (this.name != null) {
                str = str + "name=" + this.name;
            }
            str = str + "]";
            return str;
        }
    }
}

