/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.beam.sdk.io.xml.XmlIO;
import org.apache.beam.sdk.io.xml.XmlSink;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdks.java.io.xml.repackaged.com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XmlSinkTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private String testRootElement = "testElement";
    private String testFilePrefix = "/path/to/file";

    @Test
    public void testXmlWriter() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        XmlSink.XmlWriteOperation writeOp = XmlIO.write().to(this.testFilePrefix).withRecordClass(Bird.class).withRootElement("birds").createSink().createWriteOperation();
        XmlSink.XmlWriter writer = writeOp.createWriter();
        ArrayList bundle = Lists.newArrayList((Object[])new Bird[]{new Bird("bemused", "robin"), new Bird("evasive", "goose")});
        List<String> lines = Arrays.asList("<birds>", "<bird>", "<species>robin</species>", "<adjective>bemused</adjective>", "</bird>", "<bird>", "<species>goose</species>", "<adjective>evasive</adjective>", "</bird>", "</birds>");
        this.runTestWrite(writer, bundle, lines, StandardCharsets.UTF_8.name());
    }

    @Test
    public void testXmlWriterCharset() throws Exception {
        XmlSink.XmlWriteOperation writeOp = XmlIO.write().to(this.testFilePrefix).withRecordClass(Bird.class).withRootElement("birds").withCharset(StandardCharsets.ISO_8859_1).createSink().createWriteOperation();
        XmlSink.XmlWriter writer = writeOp.createWriter();
        ArrayList bundle = Lists.newArrayList((Object[])new Bird[]{new Bird("br\u00e9che", "pin\u00e7on")});
        List<String> lines = Arrays.asList("<birds>", "<bird>", "<species>pin\u00e7on</species>", "<adjective>br\u00e9che</adjective>", "</bird>", "</birds>");
        this.runTestWrite(writer, bundle, lines, StandardCharsets.ISO_8859_1.name());
    }

    @Test
    public void testBuildXmlWriteTransform() {
        XmlIO.Write write = XmlIO.write().to(this.testFilePrefix).withRecordClass(Bird.class).withRootElement(this.testRootElement);
        Assert.assertEquals(Bird.class, (Object)write.getRecordClass());
        Assert.assertEquals((Object)this.testRootElement, (Object)write.getRootElement());
        Assert.assertNotNull((Object)write.getFilenamePrefix());
        MatcherAssert.assertThat((Object)write.getFilenamePrefix().toString(), (Matcher)Matchers.containsString((String)this.testFilePrefix));
    }

    @Test
    public void testValidateXmlSinkMissingRecordClass() {
        this.thrown.expect(NullPointerException.class);
        XmlIO.write().to(this.testFilePrefix).withRootElement(this.testRootElement).validate(null);
    }

    @Test
    public void testValidateXmlSinkMissingRootElement() {
        this.thrown.expect(NullPointerException.class);
        XmlIO.write().withRecordClass(Bird.class).to(this.testFilePrefix).validate(null);
    }

    @Test
    public void testValidateXmlSinkMissingOutputDirectory() {
        this.thrown.expect(NullPointerException.class);
        XmlIO.write().withRecordClass(Bird.class).withRootElement(this.testRootElement).validate(null);
    }

    @Test
    public void testCreateWriteOperations() {
        PipelineOptions options = PipelineOptionsFactory.create();
        XmlSink sink = XmlIO.write().to(this.testFilePrefix).withRecordClass(Bird.class).withRootElement(this.testRootElement).createSink();
        XmlSink.XmlWriteOperation writeOp = sink.createWriteOperation();
        Path outputPath = new File(this.testFilePrefix).toPath();
        Path tempPath = new File(writeOp.getTemporaryDirectory().toString()).toPath();
        MatcherAssert.assertThat((Object)tempPath.getParent(), (Matcher)Matchers.equalTo((Object)outputPath.getParent()));
        MatcherAssert.assertThat((Object)tempPath.getFileName().toString(), (Matcher)Matchers.containsString((String)"temp-beam-"));
    }

    @Test
    public void testCreateWriter() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        XmlSink.XmlWriteOperation writeOp = XmlIO.write().withRecordClass(Bird.class).withRootElement(this.testRootElement).to(this.testFilePrefix).createSink().createWriteOperation();
        XmlSink.XmlWriter writer = writeOp.createWriter();
        Path outputPath = new File(this.testFilePrefix).toPath();
        Path tempPath = new File(writer.getWriteOperation().getTemporaryDirectory().toString()).toPath();
        MatcherAssert.assertThat((Object)tempPath.getParent(), (Matcher)Matchers.equalTo((Object)outputPath.getParent()));
        MatcherAssert.assertThat((Object)tempPath.getFileName().toString(), (Matcher)Matchers.containsString((String)"temp-beam-"));
        Assert.assertNotNull((Object)writer.marshaller);
    }

    @Test
    public void testDisplayData() {
        XmlIO.Write write = XmlIO.write().to(this.testFilePrefix).withRootElement("bird").withRecordClass(Integer.class);
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"filenamePattern", (String)"file-SSSSS-of-NNNNN.xml"));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"rootElement", (String)"bird"));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"recordClass", Integer.class));
    }

    private <T> void runTestWrite(XmlSink.XmlWriter<T> writer, List<T> bundle, List<String> expected, String charset) throws Exception {
        File tmpFile = this.tmpFolder.newFile("foo.txt");
        try (FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);){
            this.writeBundle(writer, bundle, fileOutputStream.getChannel());
        }
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpFile), charset));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                lines.add(line);
            }
            Assert.assertEquals(expected, lines);
        }
    }

    private <T> void writeBundle(XmlSink.XmlWriter<T> writer, List<T> elements, WritableByteChannel channel) throws Exception {
        writer.prepareWrite(channel);
        writer.writeHeader();
        for (T elem : elements) {
            writer.write(elem);
        }
        writer.writeFooter();
    }

    @XmlRootElement(name="bird")
    @XmlType(propOrder={"name", "adjective"})
    private static final class Bird {
        private String name;
        private String adjective;

        @XmlElement(name="species")
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAdjective() {
            return this.adjective;
        }

        public void setAdjective(String adjective) {
            this.adjective = adjective;
        }

        public Bird() {
        }

        public Bird(String adjective, String name) {
            this.adjective = adjective;
            this.name = name;
        }
    }
}

