/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.io.IOException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.synthetic.SyntheticRecordsCheckpoint;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.beam.sdk.io.synthetic.SyntheticTestUtils;
import org.apache.beam.sdk.io.synthetic.SyntheticUnboundedSource;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.values.KV;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SyntheticUnboundedSourceTest {
    private SyntheticSourceOptions sourceOptions;
    private SyntheticUnboundedSource source;
    private SyntheticRecordsCheckpoint checkpoint;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();

    @Before
    public void setUp() throws IOException {
        String optionsJson = "{\"numRecords\":100,\"splitPointFrequencyRecords\":10,\"keySizeBytes\":10,\"valueSizeBytes\":20,\"numHotKeys\":3,\"hotKeyFraction\":0.3,\"seed\":123456,\"bundleSizeDistribution\":{\"type\":\"const\",\"const\":42},\"forceNumInitialBundles\":10}";
        this.sourceOptions = SyntheticTestUtils.optionsFromString(optionsJson, SyntheticSourceOptions.class);
        this.source = new SyntheticUnboundedSource(this.sourceOptions);
        this.checkpoint = new SyntheticRecordsCheckpoint(0L);
    }

    @Test
    public void checkpointCoderShouldBeSane() {
        CoderProperties.coderSerializable((Coder)this.source.getCheckpointMarkCoder());
    }

    @Test
    public void coderShouldBeSane() {
        CoderProperties.coderSerializable((Coder)this.source.getOutputCoder());
    }

    @Test
    public void shouldStartTheReaderSuccessfully() throws IOException {
        UnboundedSource.UnboundedReader reader = this.source.createReader(this.pipeline.getOptions(), this.checkpoint);
        boolean isStarted = reader.start();
        Assert.assertTrue((boolean)isStarted);
    }

    @Test
    public void startPositionShouldBeExclusive() throws IOException {
        int startPosition = 0;
        this.checkpoint = new SyntheticRecordsCheckpoint((long)startPosition);
        UnboundedSource.UnboundedReader reader = this.source.createReader(this.pipeline.getOptions(), this.checkpoint);
        reader.start();
        KV currentElement = (KV)reader.getCurrent();
        KV expectedElement = this.sourceOptions.genRecord((long)((long)(startPosition + 1))).kv;
        Assert.assertEquals((Object)expectedElement, (Object)currentElement);
    }

    @Test
    public void lastElementShouldBeInclusive() throws IOException {
        int endPosition = 2;
        this.checkpoint = new SyntheticRecordsCheckpoint(0L);
        UnboundedSource.UnboundedReader reader = this.source.createReader(this.pipeline.getOptions(), this.checkpoint);
        reader.start();
        reader.advance();
        KV currentElement = (KV)reader.getCurrent();
        KV expectedElement = this.sourceOptions.genRecord((long)((long)endPosition)).kv;
        Assert.assertEquals((Object)expectedElement, (Object)currentElement);
    }

    @Test
    public void shouldCreateSplitsOfCountProvidedInOptions() throws IOException {
        this.sourceOptions.forceNumInitialBundles = 20;
        this.source = new SyntheticUnboundedSource(this.sourceOptions);
        Integer splitCount = this.source.split(100000, this.pipeline.getOptions()).size();
        Assert.assertEquals((Object)this.sourceOptions.forceNumInitialBundles, (Object)splitCount);
    }
}

