/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.beam.sdk.io.synthetic.SyntheticOptions;
import org.apache.beam.sdk.io.synthetic.SyntheticTestUtils;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SyntheticOptionsTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testInvalidDelayDistribution() throws Exception {
        this.thrown.expect(JsonMappingException.class);
        String syntheticOptions = "{\"delayDistribution\":\"0\"}";
        SyntheticTestUtils.optionsFromString(syntheticOptions, SyntheticOptions.class);
    }

    @Test
    public void testSyntheticOptionsWithNegativeKeySize() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("keySizeBytes should be a positive number, but found -64");
        String options = "{\"keySizeBytes\":-64}";
        SyntheticTestUtils.optionsFromString(options, SyntheticOptions.class);
    }

    @Test
    public void testSyntheticOptionsWithNegativeHotKeyFraction() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("hotKeyFraction should be a non-negative number, but found -0.25");
        String options = "{\"hotKeyFraction\":-0.25}";
        SyntheticTestUtils.optionsFromString(options, SyntheticOptions.class);
    }

    @Test
    public void testRealDistributionDeserializerWithNegativeLowerBound() throws Exception {
        this.thrown.expect(JsonMappingException.class);
        this.thrown.expectMessage("lower bound of uniform distribution should be a non-negative number, but found -100.0");
        String syntheticOptions = "{\"delayDistribution\":{\"type\":\"uniform\",\"lower\":-100,\"upper\":200}}";
        SyntheticTestUtils.optionsFromString(syntheticOptions, SyntheticOptions.class);
    }

    @Test
    public void testRealDistributionDeserializerWithUniformDistribution() throws Exception {
        String syntheticOptions = "{\"seed\":12345,\"delayDistribution\":{\"type\":\"uniform\",\"lower\":0,\"upper\":100}}";
        SyntheticOptions sourceOptions = SyntheticTestUtils.optionsFromString(syntheticOptions, SyntheticOptions.class);
        Assert.assertEquals((long)0L, (long)((long)((UniformRealDistribution)sourceOptions.delayDistribution.getDistribution()).getSupportLowerBound()));
        Assert.assertEquals((long)100L, (long)((long)((UniformRealDistribution)sourceOptions.delayDistribution.getDistribution()).getSupportUpperBound()));
    }

    @Test
    public void testRealDistributionDeserializerWithNormalDistribution() throws Exception {
        String syntheticOptions = "{\"seed\":12345,\"delayDistribution\":{\"type\":\"normal\",\"mean\":100,\"stddev\":50}}";
        SyntheticOptions sourceOptions = SyntheticTestUtils.optionsFromString(syntheticOptions, SyntheticOptions.class);
        Assert.assertEquals((long)100L, (long)((long)((NormalDistribution)sourceOptions.delayDistribution.getDistribution()).getMean()));
        Assert.assertEquals((long)50L, (long)((long)((NormalDistribution)sourceOptions.delayDistribution.getDistribution()).getStandardDeviation()));
    }

    @Test
    public void testRealDistributionDeserializerWithExpDistribution() throws Exception {
        String syntheticOptions = "{\"seed\":12345,\"delayDistribution\":{\"type\":\"exp\",\"mean\":10}}";
        SyntheticOptions sourceOptions = SyntheticTestUtils.optionsFromString(syntheticOptions, SyntheticOptions.class);
        Assert.assertEquals((long)10L, (long)((long)((ExponentialDistribution)sourceOptions.delayDistribution.getDistribution()).getMean()));
    }

    @Test
    public void testValidateHotKeys() {
        SyntheticOptions options = new SyntheticOptions();
        options.keySizeBytes = 1L;
        options.hotKeyFraction = 0.1;
        options.numHotKeys = 123L;
        options.setSeed(12345);
        this.thrown.expect(IllegalArgumentException.class);
        options.validate();
    }

    @Test
    public void testGenerateKvPairWithHotKey() {
        SyntheticOptions options = new SyntheticOptions();
        options.keySizeBytes = 4L;
        options.hotKeyFraction = 1.0;
        options.numHotKeys = 123L;
        options.setSeed(12345);
        options.genKvPair(34567L);
    }

    @Test
    public void testGenerateKvPairWithRegularKey() {
        SyntheticOptions options = new SyntheticOptions();
        options.keySizeBytes = 3L;
        options.hotKeyFraction = 0.0;
        options.numHotKeys = 123L;
        options.setSeed(12345);
        options.genKvPair(34567L);
    }
}

