/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.synthetic.SyntheticBoundedSource;
import org.apache.beam.sdk.io.synthetic.SyntheticOptions;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.SourceTestUtils;
import org.apache.commons.math3.distribution.ConstantRealDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.ZipfDistribution;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SyntheticBoundedSourceTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private SyntheticSourceOptions testSourceOptions = new SyntheticSourceOptions();

    @Before
    public void setUp() {
        this.testSourceOptions.splitPointFrequencyRecords = 1L;
        this.testSourceOptions.numRecords = 10L;
        this.testSourceOptions.keySizeBytes = 10L;
        this.testSourceOptions.valueSizeBytes = 20L;
        this.testSourceOptions.numHotKeys = 3L;
        this.testSourceOptions.hotKeyFraction = 0.3;
        this.testSourceOptions.setSeed(123456);
        this.testSourceOptions.bundleSizeDistribution = SyntheticOptions.fromIntegerDistribution((IntegerDistribution)new ZipfDistribution(100, 2.5));
        this.testSourceOptions.forceNumInitialBundles = null;
    }

    private SyntheticSourceOptions fromString(String jsonString) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SyntheticSourceOptions result = (SyntheticSourceOptions)mapper.readValue(jsonString, SyntheticSourceOptions.class);
        result.validate();
        return result;
    }

    @Test
    public void testInvalidSourceOptionsJsonFormat() throws Exception {
        this.thrown.expect(JsonParseException.class);
        String syntheticSourceOptions = "input:unknown URI";
        this.fromString(syntheticSourceOptions);
    }

    @Test
    public void testFromString() throws Exception {
        String syntheticSourceOptions = "{\"numRecords\":100,\"splitPointFrequencyRecords\":10,\"keySizeBytes\":10,\"valueSizeBytes\":20,\"numHotKeys\":3,\"hotKeyFraction\":0.3,\"seed\":123456,\"bundleSizeDistribution\":{\"type\":\"const\",\"const\":42},\"forceNumInitialBundles\":10,\"progressShape\":\"LINEAR_REGRESSING\"}";
        SyntheticSourceOptions sourceOptions = this.fromString(syntheticSourceOptions);
        Assert.assertEquals((long)100L, (long)sourceOptions.numRecords);
        Assert.assertEquals((long)10L, (long)sourceOptions.splitPointFrequencyRecords);
        Assert.assertEquals((long)10L, (long)sourceOptions.keySizeBytes);
        Assert.assertEquals((long)20L, (long)sourceOptions.valueSizeBytes);
        Assert.assertEquals((long)3L, (long)sourceOptions.numHotKeys);
        Assert.assertEquals((double)0.3, (double)sourceOptions.hotKeyFraction, (double)0.0);
        Assert.assertEquals((long)0L, (long)sourceOptions.nextDelay((long)sourceOptions.seed));
        Assert.assertEquals((long)123456L, (long)sourceOptions.seed);
        Assert.assertEquals((double)42.0, (double)sourceOptions.bundleSizeDistribution.sample(123L), (double)0.0);
        Assert.assertEquals((long)10L, (long)sourceOptions.forceNumInitialBundles.intValue());
        Assert.assertEquals((Object)SyntheticSourceOptions.ProgressShape.LINEAR_REGRESSING, (Object)sourceOptions.progressShape);
    }

    @Test
    public void testSourceOptionsWithNegativeNumRecords() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("numRecords should be a non-negative number, but found -100");
        this.testSourceOptions.numRecords = -100L;
        this.testSourceOptions.validate();
    }

    @Test
    public void testSourceAndReadersWork() throws Exception {
        this.testSourceAndReadersWorkP(1L);
        this.testSourceAndReadersWorkP(-1L);
        this.testSourceAndReadersWorkP(3L);
    }

    private void testSourceAndReadersWorkP(long splitPointFrequency) throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        this.testSourceOptions.splitPointFrequencyRecords = splitPointFrequency;
        SyntheticBoundedSource source = new SyntheticBoundedSource(this.testSourceOptions);
        Assert.assertEquals((long)300L, (long)source.getEstimatedSizeBytes(options));
        SourceTestUtils.assertUnstartedReaderReadsSameAsItsSource((BoundedSource.BoundedReader)source.createReader(options), (PipelineOptions)options);
    }

    @Test
    public void testSplitAtFraction() throws Exception {
        this.testSplitAtFractionP(1L);
        this.testSplitAtFractionP(3L);
    }

    private void testSplitAtFractionP(long splitPointFrequency) throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        this.testSourceOptions.splitPointFrequencyRecords = splitPointFrequency;
        SyntheticBoundedSource source = new SyntheticBoundedSource(this.testSourceOptions);
        SourceTestUtils.assertSplitAtFractionExhaustive((BoundedSource)source, (PipelineOptions)options);
        SourceTestUtils.assertSplitAtFractionFails((BoundedSource)source, (int)5, (double)0.3, (PipelineOptions)options);
        SourceTestUtils.assertSplitAtFractionSucceedsAndConsistent((BoundedSource)source, (int)1, (double)0.3, (PipelineOptions)options);
    }

    @Test
    public void testSplitIntoBundles() throws Exception {
        this.testSplitIntoBundlesP(1L);
        this.testSplitIntoBundlesP(-1L);
        this.testSplitIntoBundlesP(5L);
        PipelineOptions options = PipelineOptionsFactory.create();
        this.testSourceOptions.forceNumInitialBundles = 37;
        Assert.assertEquals((long)37L, (long)new SyntheticBoundedSource(this.testSourceOptions).split(42L, options).size());
    }

    private void testSplitIntoBundlesP(long splitPointFrequency) throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        this.testSourceOptions.splitPointFrequencyRecords = splitPointFrequency;
        this.testSourceOptions.numRecords = 100L;
        SyntheticBoundedSource source = new SyntheticBoundedSource(this.testSourceOptions);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)source.split(10L, options), (PipelineOptions)options);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)source.split(40L, options), (PipelineOptions)options);
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)source.split(100L, options), (PipelineOptions)options);
    }

    @Test
    public void testIncreasingProgress() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        this.testSourceOptions.progressShape = SyntheticSourceOptions.ProgressShape.LINEAR;
        SyntheticBoundedSource source = new SyntheticBoundedSource(this.testSourceOptions);
        SyntheticBoundedSource.SyntheticSourceReader reader = source.createReader(options);
        Assert.assertEquals((double)0.0, (double)reader.getFractionConsumed(), (double)1.0E-5);
        double lastFractionConsumed = -1.0;
        boolean more = reader.start();
        while (more) {
            Assert.assertTrue((reader.getFractionConsumed() > lastFractionConsumed ? 1 : 0) != 0);
            lastFractionConsumed = reader.getFractionConsumed();
            more = reader.advance();
        }
        Assert.assertEquals((double)1.0, (double)reader.getFractionConsumed(), (double)1.0E-5);
    }

    @Test
    public void testRegressingProgress() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        this.testSourceOptions.progressShape = SyntheticSourceOptions.ProgressShape.LINEAR_REGRESSING;
        SyntheticBoundedSource source = new SyntheticBoundedSource(this.testSourceOptions);
        SyntheticBoundedSource.SyntheticSourceReader reader = source.createReader(options);
        double lastFractionConsumed = reader.getFractionConsumed();
        boolean more = reader.start();
        while (more) {
            Assert.assertTrue((reader.getFractionConsumed() <= lastFractionConsumed ? 1 : 0) != 0);
            lastFractionConsumed = reader.getFractionConsumed();
            more = reader.advance();
        }
    }

    @Test
    public void testSplitIntoSingleRecordBundles() throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        SyntheticSourceOptions sourceOptions = new SyntheticSourceOptions();
        sourceOptions.numRecords = 10L;
        sourceOptions.setSeed(123456);
        sourceOptions.bundleSizeDistribution = SyntheticOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(1.0));
        sourceOptions.forceNumInitialBundles = 10;
        SyntheticBoundedSource source = new SyntheticBoundedSource(sourceOptions);
        List sources = source.split(42L, options);
        for (SyntheticBoundedSource recordSource : sources) {
            recordSource.validate();
            Assert.assertEquals((long)1L, (long)(recordSource.getEndOffset() - recordSource.getStartOffset()));
        }
        SourceTestUtils.assertSourcesEqualReferenceSource((BoundedSource)source, (List)sources, (PipelineOptions)options);
    }
}

