/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.util.List;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.io.synthetic.BundleSplitter;
import org.apache.beam.sdk.io.synthetic.SyntheticOptions;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.commons.math3.distribution.ConstantRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BundleSplitterTest {
    private SyntheticSourceOptions options;
    private BundleSplitter splitter;

    @Before
    public void setUp() throws Exception {
        this.options = new SyntheticSourceOptions();
        this.options.numRecords = 8L;
        this.options.keySizeBytes = 1L;
        this.options.valueSizeBytes = 1L;
        this.splitter = new BundleSplitter(this.options);
    }

    @Test
    public void shouldCreateAsManyBundlesAsItsDesired() {
        this.splitter = new BundleSplitter(this.options);
        int expectedBundleCount = 4;
        List bundleSizes = this.splitter.getBundleSizes(expectedBundleCount, 0L, this.options.numRecords);
        Assert.assertEquals((long)expectedBundleCount, (long)bundleSizes.size());
    }

    @Test
    public void bundlesShouldBeEvenForConstDistribution() {
        long expectedBundleSize = 2L;
        this.options.bundleSizeDistribution = SyntheticOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(2.0));
        this.splitter = new BundleSplitter(this.options);
        List bundleSizes = this.splitter.getBundleSizes(4, 0L, this.options.numRecords);
        bundleSizes.stream().map(range -> range.getTo() - range.getFrom()).forEach(size -> Assert.assertEquals((long)expectedBundleSize, (long)size.intValue()));
    }

    @Test
    public void bundleSizesShouldBeProportionalToTheOneSuggestedInBundleSizeDistribution() {
        long expectedBundleSize = 4L;
        this.options.bundleSizeDistribution = SyntheticOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(2.0));
        this.options.numRecords = 16L;
        this.splitter = new BundleSplitter(this.options);
        List bundleSizes = this.splitter.getBundleSizes(4, 0L, this.options.numRecords);
        bundleSizes.stream().map(range -> range.getTo() - range.getFrom()).forEach(size -> Assert.assertEquals((long)expectedBundleSize, (long)size.intValue()));
    }

    @Test
    public void consequentBundlesShouldHaveTheSameRangeEndAndStart() {
        int desiredNumberOfBundles = 2;
        this.options.bundleSizeDistribution = SyntheticOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(2.0));
        this.splitter = new BundleSplitter(this.options);
        List bundleSizes = this.splitter.getBundleSizes(desiredNumberOfBundles, 0L, this.options.numRecords);
        Assert.assertEquals((long)((OffsetRange)bundleSizes.get(0)).getTo(), (long)((OffsetRange)bundleSizes.get(1)).getFrom());
        Assert.assertEquals((long)((OffsetRange)bundleSizes.get(0)).getTo(), (long)((OffsetRange)bundleSizes.get(1)).getFrom());
        Assert.assertEquals((long)desiredNumberOfBundles, (long)bundleSizes.size());
    }
}

