/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.beam.sdk.io.synthetic.SyntheticOptions;
import org.apache.beam.sdk.io.synthetic.SyntheticStep;
import org.apache.beam.sdk.io.synthetic.SyntheticTestUtils;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Keys;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.commons.math3.distribution.ConstantRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SyntheticStepTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final transient TestPipeline p = TestPipeline.create();

    private byte[] intToByteArray(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    @Test
    public void testSyntheticStepWithPreservingInputKeyDistribution() throws Exception {
        SyntheticStep.Options options = SyntheticTestUtils.optionsFromString("{\"outputRecordsPerInputRecord\": 2, \"preservesInputKeyDistribution\": true,\"keySizeBytes\": 10,\"valueSizeBytes\": 20,\"numHotKeys\": 3,\"hotKeyFraction\": 0.3,\"seed\": 123456}", SyntheticStep.Options.class);
        options.delayDistribution = SyntheticOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(10.0));
        PCollection result = (PCollection)((PCollection)((PCollection)this.p.apply((PTransform)Create.of((Iterable)ImmutableList.of((Object)KV.of((Object)this.intToByteArray(1), (Object)this.intToByteArray(11)), (Object)KV.of((Object)this.intToByteArray(2), (Object)this.intToByteArray(22)), (Object)KV.of((Object)this.intToByteArray(3), (Object)this.intToByteArray(33)))))).apply((PTransform)ParDo.of((DoFn)new SyntheticStep(options)))).apply((PTransform)Keys.create());
        ImmutableList expected = ImmutableList.of((Object)this.intToByteArray(1), (Object)this.intToByteArray(1), (Object)this.intToByteArray(2), (Object)this.intToByteArray(2), (Object)this.intToByteArray(3), (Object)this.intToByteArray(3));
        PAssert.that((PCollection)result).containsInAnyOrder((Iterable)expected);
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testSyntheticStepWithoutPreservingInputKeyDistribution() throws Exception {
        SyntheticStep.Options options = SyntheticTestUtils.optionsFromString("{\"outputRecordsPerInputRecord\": 2, \"preservesInputKeyDistribution\": false,\"keySizeBytes\": 10,\"valueSizeBytes\": 20,\"numHotKeys\": 3,\"hotKeyFraction\": 0.3,\"seed\": 123456}", SyntheticStep.Options.class);
        options.delayDistribution = SyntheticOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(10.0));
        PCollection result = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Iterable)ImmutableList.of((Object)KV.of((Object)this.intToByteArray(1), (Object)this.intToByteArray(11)))))).apply((PTransform)ParDo.of((DoFn)new SyntheticStep(options)));
        PAssert.that((PCollection)result).satisfies((SerializableFunction & Serializable)input -> {
            int count = 0;
            for (KV elm : input) {
                ++count;
                Assert.assertEquals((long)10L, (long)((byte[])elm.getKey()).length);
                Assert.assertEquals((long)20L, (long)((byte[])elm.getValue()).length);
            }
            Assert.assertEquals((long)2L, (long)count);
            return null;
        });
        this.p.run().waitUntilFinish();
    }
}

