/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_io_synthetic.com.google.common.collect;

import org.apache.beam.repackaged.beam_sdks_java_io_synthetic.com.google.common.annotations.GwtCompatible;
import org.apache.beam.repackaged.beam_sdks_java_io_synthetic.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_io_synthetic.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_io_synthetic.com.google.common.collect.Iterators;
import org.apache.beam.repackaged.beam_sdks_java_io_synthetic.com.google.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableList<E>
extends ImmutableList<E> {
    final transient E element;

    SingletonImmutableList(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    @Override
    public E get(int index) {
        Preconditions.checkElementIndex(index, 1);
        return this.element;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, 1);
        return fromIndex == toIndex ? ImmutableList.of() : this;
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

