/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.repackaged.core.org.apache.commons.compress.utils.IOUtils;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.splunk.AutoValue_SplunkEventWriter;
import org.apache.beam.sdk.io.splunk.HttpEventPublisher;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.sdk.io.splunk.SplunkWriteError;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.net.InetAddresses;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.net.InternetDomainName;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
abstract class SplunkEventWriter
extends DoFn<KV<Integer, SplunkEvent>, SplunkWriteError> {
    private static final @UnknownKeyFor @NonNull @Initialized Integer DEFAULT_BATCH_COUNT = 10;
    private static final @UnknownKeyFor @NonNull @Initialized Boolean DEFAULT_DISABLE_CERTIFICATE_VALIDATION = false;
    private static final @UnknownKeyFor @NonNull @Initialized Boolean DEFAULT_ENABLE_BATCH_LOGS = true;
    private static final @UnknownKeyFor @NonNull @Initialized Boolean DEFAULT_ENABLE_GZIP_HTTP_COMPRESSION = true;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SplunkEventWriter.class);
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_FLUSH_DELAY = 2L;
    private static final @UnknownKeyFor @NonNull @Initialized Counter INPUT_COUNTER = Metrics.counter(SplunkEventWriter.class, (String)"inbound-events");
    private static final @UnknownKeyFor @NonNull @Initialized Counter SUCCESS_WRITES = Metrics.counter(SplunkEventWriter.class, (String)"outbound-successful-events");
    private static final @UnknownKeyFor @NonNull @Initialized Counter FAILED_WRITES = Metrics.counter(SplunkEventWriter.class, (String)"outbound-failed-events");
    private static final @UnknownKeyFor @NonNull @Initialized Counter INVALID_REQUESTS = Metrics.counter(SplunkEventWriter.class, (String)"http-invalid-requests");
    private static final @UnknownKeyFor @NonNull @Initialized Counter SERVER_ERROR_REQUESTS = Metrics.counter(SplunkEventWriter.class, (String)"http-server-error-requests");
    private static final @UnknownKeyFor @NonNull @Initialized Counter VALID_REQUESTS = Metrics.counter(SplunkEventWriter.class, (String)"http-valid-requests");
    private static final @UnknownKeyFor @NonNull @Initialized Distribution SUCCESSFUL_WRITE_LATENCY_MS = Metrics.distribution(SplunkEventWriter.class, (String)"successful_write_to_splunk_latency_ms");
    private static final @UnknownKeyFor @NonNull @Initialized Distribution UNSUCCESSFUL_WRITE_LATENCY_MS = Metrics.distribution(SplunkEventWriter.class, (String)"unsuccessful_write_to_splunk_latency_ms");
    private static final @UnknownKeyFor @NonNull @Initialized Distribution SUCCESSFUL_WRITE_BATCH_SIZE = Metrics.distribution(SplunkEventWriter.class, (String)"write_to_splunk_batch");
    private static final @UnknownKeyFor @NonNull @Initialized String BUFFER_STATE_NAME = "buffer";
    private static final @UnknownKeyFor @NonNull @Initialized String COUNT_STATE_NAME = "count";
    private static final @UnknownKeyFor @NonNull @Initialized String TIME_ID_NAME = "expiry";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern URL_PATTERN = Pattern.compile("^http(s?)://([^:]+)(:[0-9]+)?$");
    @VisibleForTesting
    protected static final @UnknownKeyFor @NonNull @Initialized String INVALID_URL_FORMAT_MESSAGE = "Invalid url format. Url format should match PROTOCOL://HOST[:PORT], where PORT is optional. Supported Protocols are http and https. eg: http://hostname:8088";
    @DoFn.StateId(value="buffer")
    private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized SplunkEvent>> buffer = StateSpecs.bag();
    @DoFn.StateId(value="count")
    private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long>> count = StateSpecs.value();
    @DoFn.TimerId(value="expiry")
    private final @UnknownKeyFor @NonNull @Initialized TimerSpec expirySpec = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);
    private @UnknownKeyFor @NonNull @Initialized Integer batchCount;
    private @UnknownKeyFor @NonNull @Initialized Boolean disableValidation;
    private @UnknownKeyFor @NonNull @Initialized HttpEventPublisher publisher;
    private @UnknownKeyFor @NonNull @Initialized Boolean enableBatchLogs;
    private @UnknownKeyFor @NonNull @Initialized Boolean enableGzipHttpCompression;
    private static final @UnknownKeyFor @NonNull @Initialized Gson GSON = new GsonBuilder().setFieldNamingStrategy(f -> f.getName().toLowerCase()).create();

    SplunkEventWriter() {
    }

    static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_SplunkEventWriter.Builder();
    }

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> url();

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> token();

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> disableCertificateValidation();

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> inputBatchCount();

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rootCaCertificatePath();

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> enableBatchLogs();

    abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> enableGzipHttpCompression();

    @DoFn.Setup
    public void setup() {
        Preconditions.checkArgument((boolean)this.url().isAccessible(), (Object)"url is required for writing events.");
        Preconditions.checkArgument((boolean)SplunkEventWriter.isValidUrlFormat((String)this.url().get()), (Object)INVALID_URL_FORMAT_MESSAGE);
        Preconditions.checkArgument((boolean)this.token().isAccessible(), (Object)"Access token is required for writing events.");
        if (this.batchCount == null) {
            if (this.inputBatchCount() != null) {
                this.batchCount = (Integer)this.inputBatchCount().get();
            }
            this.batchCount = (Integer)MoreObjects.firstNonNull((Object)this.batchCount, (Object)DEFAULT_BATCH_COUNT);
            LOG.info("Batch count set to: {}", (Object)this.batchCount);
        }
        if (this.disableValidation == null) {
            if (this.disableCertificateValidation() != null) {
                this.disableValidation = (Boolean)this.disableCertificateValidation().get();
            }
            this.disableValidation = (Boolean)MoreObjects.firstNonNull((Object)this.disableValidation, (Object)DEFAULT_DISABLE_CERTIFICATE_VALIDATION);
            LOG.info("Disable certificate validation set to: {}", (Object)this.disableValidation);
        }
        if (this.enableBatchLogs == null) {
            if (this.enableBatchLogs() != null) {
                this.enableBatchLogs = (Boolean)this.enableBatchLogs().get();
            }
            this.enableBatchLogs = (Boolean)MoreObjects.firstNonNull((Object)this.enableBatchLogs, (Object)DEFAULT_ENABLE_BATCH_LOGS);
            LOG.info("Enable Batch logs set to: {}", (Object)this.enableBatchLogs);
        }
        if (this.enableGzipHttpCompression == null) {
            if (this.enableGzipHttpCompression() != null) {
                this.enableGzipHttpCompression = (Boolean)this.enableGzipHttpCompression().get();
            }
            this.enableGzipHttpCompression = (Boolean)MoreObjects.firstNonNull((Object)this.enableGzipHttpCompression, (Object)DEFAULT_ENABLE_GZIP_HTTP_COMPRESSION);
            LOG.info("Enable gzip http compression set to: {}", (Object)this.enableGzipHttpCompression);
        }
        try {
            HttpEventPublisher.Builder builder = HttpEventPublisher.newBuilder().withUrl((String)this.url().get()).withToken((String)this.token().get()).withDisableCertificateValidation(this.disableValidation).withEnableGzipHttpCompression(this.enableGzipHttpCompression);
            if (this.rootCaCertificatePath() != null && this.rootCaCertificatePath().get() != null) {
                builder.withRootCaCertificate(SplunkEventWriter.getCertFromGcsAsBytes((String)this.rootCaCertificatePath().get()));
            }
            this.publisher = builder.build();
            LOG.info("Successfully created HttpEventPublisher");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.error("Error creating HttpEventPublisher: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized SplunkEvent> input, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SplunkWriteError> receiver, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @DoFn.StateId(value="buffer") @UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized SplunkEvent> bufferState, @DoFn.StateId(value="count") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> countState, @DoFn.TimerId(value="expiry") @UnknownKeyFor @NonNull @Initialized Timer timer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Long count = (Long)MoreObjects.firstNonNull((Object)((Long)countState.read()), (Object)0L);
        SplunkEvent event = (SplunkEvent)input.getValue();
        INPUT_COUNTER.inc();
        bufferState.add((Object)event);
        count = count + 1L;
        countState.write((Object)count);
        timer.offset(Duration.standardSeconds((long)2L)).setRelative();
        if (count >= (long)this.batchCount.intValue()) {
            if (this.enableBatchLogs.booleanValue()) {
                LOG.info("Flushing batch of {} events", (Object)count);
            }
            this.flush(receiver, bufferState, countState);
        }
    }

    @DoFn.OnTimer(value="expiry")
    public void onExpiry(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SplunkWriteError> receiver, @DoFn.StateId(value="buffer") @UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized SplunkEvent> bufferState, @DoFn.StateId(value="count") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> countState) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if ((Long)MoreObjects.firstNonNull((Object)((Long)countState.read()), (Object)0L) > 0L) {
            if (this.enableBatchLogs.booleanValue()) {
                LOG.info("Flushing window with {} events", countState.read());
            }
            this.flush(receiver, bufferState, countState);
        }
    }

    @DoFn.Teardown
    public void tearDown() {
        if (this.publisher != null) {
            try {
                this.publisher.close();
                LOG.info("Successfully closed HttpEventPublisher");
            }
            catch (IOException e) {
                LOG.warn("Received exception while closing HttpEventPublisher: {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SplunkWriteError> receiver, @UnknownKeyFor @NonNull @Initialized BagState<@UnknownKeyFor @NonNull @Initialized SplunkEvent> bufferState, @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> countState) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!((Boolean)bufferState.isEmpty().read()).booleanValue()) {
            HttpResponse response = null;
            ArrayList events = Lists.newArrayList((Iterable)bufferState.read());
            long startTime = System.nanoTime();
            try {
                response = this.publisher.execute(events);
                if (!response.isSuccessStatusCode()) {
                    UNSUCCESSFUL_WRITE_LATENCY_MS.update(SplunkEventWriter.nanosToMillis(System.nanoTime() - startTime));
                    FAILED_WRITES.inc(((Long)countState.read()).longValue());
                    int statusCode = response.getStatusCode();
                    if (statusCode >= 400 && statusCode < 500) {
                        INVALID_REQUESTS.inc();
                    } else if (statusCode >= 500 && statusCode < 600) {
                        SERVER_ERROR_REQUESTS.inc();
                    }
                    this.logWriteFailures(countState, response.getStatusCode(), response.parseAsString(), response.getStatusMessage());
                    SplunkEventWriter.flushWriteFailures(events, response.getStatusMessage(), response.getStatusCode(), receiver);
                } else {
                    SUCCESSFUL_WRITE_LATENCY_MS.update(SplunkEventWriter.nanosToMillis(System.nanoTime() - startTime));
                    SUCCESS_WRITES.inc(((Long)countState.read()).longValue());
                    VALID_REQUESTS.inc();
                    SUCCESSFUL_WRITE_BATCH_SIZE.update(((Long)countState.read()).longValue());
                    if (this.enableBatchLogs.booleanValue()) {
                        LOG.info("Successfully wrote {} events", countState.read());
                    }
                }
            }
            catch (HttpResponseException e) {
                LOG.error("Error writing to Splunk. StatusCode: {}, content: {}, StatusMessage: {}", new Object[]{e.getStatusCode(), e.getContent(), e.getStatusMessage()});
                UNSUCCESSFUL_WRITE_LATENCY_MS.update(SplunkEventWriter.nanosToMillis(System.nanoTime() - startTime));
                FAILED_WRITES.inc(((Long)countState.read()).longValue());
                int statusCode = e.getStatusCode();
                if (statusCode >= 400 && statusCode < 500) {
                    INVALID_REQUESTS.inc();
                } else if (statusCode >= 500 && statusCode < 600) {
                    SERVER_ERROR_REQUESTS.inc();
                }
                this.logWriteFailures(countState, e.getStatusCode(), e.getContent(), e.getStatusMessage());
                SplunkEventWriter.flushWriteFailures(events, e.getStatusMessage(), e.getStatusCode(), receiver);
            }
            catch (IOException ioe) {
                LOG.error("Error writing to Splunk: {}", (Object)ioe.getMessage());
                UNSUCCESSFUL_WRITE_LATENCY_MS.update(SplunkEventWriter.nanosToMillis(System.nanoTime() - startTime));
                FAILED_WRITES.inc(((Long)countState.read()).longValue());
                INVALID_REQUESTS.inc();
                this.logWriteFailures(countState, 0, ioe.getMessage(), null);
                SplunkEventWriter.flushWriteFailures(events, ioe.getMessage(), null, receiver);
            }
            finally {
                bufferState.clear();
                countState.clear();
                try {
                    if (response != null) {
                        response.ignore();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Error ignoring response from Splunk. Messages should still have published, but there might be a connection leak.", (Throwable)e);
                }
            }
        }
    }

    private void logWriteFailures(@DoFn.StateId(value="count") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> countState, @UnknownKeyFor @NonNull @Initialized int statusCode, @UnknownKeyFor @NonNull @Initialized String content, @UnknownKeyFor @NonNull @Initialized String statusMessage) {
        if (this.enableBatchLogs.booleanValue()) {
            LOG.error("Failed to write {} events", countState.read());
        }
        LOG.error("Error writing to Splunk. StatusCode: {}, content: {}, StatusMessage: {}", new Object[]{statusCode, content, statusMessage});
    }

    private static void flushWriteFailures(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SplunkEvent> events, @UnknownKeyFor @NonNull @Initialized String statusMessage, @UnknownKeyFor @NonNull @Initialized Integer statusCode, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SplunkWriteError> receiver) {
        Preconditions.checkNotNull(events, (Object)"events cannot be null.");
        SplunkWriteError.Builder builder = SplunkWriteError.newBuilder();
        if (statusMessage != null) {
            builder.withStatusMessage(statusMessage);
        }
        if (statusCode != null) {
            builder.withStatusCode(statusCode);
        }
        for (SplunkEvent event : events) {
            String payload = GSON.toJson((Object)event);
            SplunkWriteError error = builder.withPayload(payload).create();
            receiver.output((Object)error);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCertFromGcsAsBytes(@UnknownKeyFor @NonNull @Initialized String filePath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        MatchResult.Metadata fileMetadata = FileSystems.matchSingleFileSpec((String)filePath);
        ReadableByteChannel channel = FileSystems.open((ResourceId)fileMetadata.resourceId());
        try (InputStream inputStream = Channels.newInputStream(channel);){
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error when reading: " + filePath, e);
        }
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized boolean isValidUrlFormat(@UnknownKeyFor @NonNull @Initialized String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (matcher.find()) {
            String host = matcher.group(2);
            return InetAddresses.isInetAddress((String)host) || InternetDomainName.isValid((String)host);
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized long nanosToMillis(@UnknownKeyFor @NonNull @Initialized long ns) {
        return Math.round((double)ns / 1000000.0);
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setUrl(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> url();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setToken(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> token();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setDisableCertificateValidation(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setRootCaCertificatePath(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setEnableBatchLogs(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setEnableGzipHttpCompression(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setInputBatchCount(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

        abstract @UnknownKeyFor @NonNull @Initialized SplunkEventWriter autoBuild();

        @UnknownKeyFor @NonNull @Initialized Builder withUrl(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> url) {
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"withURL(url) called with null input.");
            if (url.isAccessible()) {
                Preconditions.checkArgument((boolean)SplunkEventWriter.isValidUrlFormat((String)url.get()), (Object)SplunkEventWriter.INVALID_URL_FORMAT_MESSAGE);
            }
            return this.setUrl(url);
        }

        @UnknownKeyFor @NonNull @Initialized Builder withUrl(@UnknownKeyFor @NonNull @Initialized String url) {
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"withURL(url) called with null input.");
            Preconditions.checkArgument((boolean)SplunkEventWriter.isValidUrlFormat(url), (Object)SplunkEventWriter.INVALID_URL_FORMAT_MESSAGE);
            return this.setUrl((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)url));
        }

        @UnknownKeyFor @NonNull @Initialized Builder withToken(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> token) {
            Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"withToken(token) called with null input.");
            return this.setToken(token);
        }

        @UnknownKeyFor @NonNull @Initialized Builder withToken(@UnknownKeyFor @NonNull @Initialized String token) {
            Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"withToken(token) called with null input.");
            return this.setToken((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)token));
        }

        @UnknownKeyFor @NonNull @Initialized Builder withInputBatchCount(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> inputBatchCount) {
            return this.setInputBatchCount(inputBatchCount);
        }

        @UnknownKeyFor @NonNull @Initialized Builder withDisableCertificateValidation(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> disableCertificateValidation) {
            return this.setDisableCertificateValidation(disableCertificateValidation);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withRootCaCertificatePath(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rootCaCertificatePath) {
            return this.setRootCaCertificatePath(rootCaCertificatePath);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withEnableBatchLogs(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> enableBatchLogs) {
            return this.setEnableBatchLogs(enableBatchLogs);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withEnableGzipHttpCompression(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> enableGzipHttpCompression) {
            return this.setEnableGzipHttpCompression(enableGzipHttpCompression);
        }

        @UnknownKeyFor @NonNull @Initialized SplunkEventWriter build() {
            Preconditions.checkNotNull(this.url(), (Object)"url needs to be provided.");
            Preconditions.checkNotNull(this.token(), (Object)"token needs to be provided.");
            return this.autoBuild();
        }
    }
}

