/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CustomX509TrustManager
implements X509TrustManager {
    private final @Nullable @UnknownKeyFor @Initialized X509TrustManager defaultTrustManager;
    private final @Nullable @UnknownKeyFor @Initialized X509TrustManager userTrustManager;

    public CustomX509TrustManager(@UnknownKeyFor @NonNull @Initialized X509Certificate userCertificate) throws @UnknownKeyFor @NonNull @Initialized CertificateException, @UnknownKeyFor @NonNull @Initialized KeyStoreException, @UnknownKeyFor @NonNull @Initialized NoSuchAlgorithmException, @UnknownKeyFor @NonNull @Initialized IOException {
        TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustMgrFactory.init((KeyStore)null);
        this.defaultTrustManager = this.getX509TrustManager(trustMgrFactory.getTrustManagers());
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setCertificateEntry("User Provided Root CA", userCertificate);
        trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustMgrFactory.init(trustStore);
        this.userTrustManager = this.getX509TrustManager(trustMgrFactory.getTrustManagers());
    }

    private @Nullable @UnknownKeyFor @Initialized X509TrustManager getX509TrustManager(@UnknownInitialization CustomX509TrustManager this, @UnknownKeyFor @NonNull @Initialized TrustManager @UnknownKeyFor @NonNull @Initialized [] trustManagers) {
        for (TrustManager tm : trustManagers) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }

    @Override
    public void checkClientTrusted(@UnknownKeyFor @NonNull @Initialized X509Certificate @UnknownKeyFor @NonNull @Initialized [] chain, @UnknownKeyFor @NonNull @Initialized String authType) throws @UnknownKeyFor @NonNull @Initialized CertificateException {
        if (this.defaultTrustManager != null) {
            this.defaultTrustManager.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public void checkServerTrusted(@UnknownKeyFor @NonNull @Initialized X509Certificate @UnknownKeyFor @NonNull @Initialized [] chain, @UnknownKeyFor @NonNull @Initialized String authType) throws @UnknownKeyFor @NonNull @Initialized CertificateException {
        block3: {
            try {
                if (this.defaultTrustManager != null) {
                    this.defaultTrustManager.checkServerTrusted(chain, authType);
                }
            }
            catch (CertificateException ce) {
                if (this.userTrustManager == null) break block3;
                this.userTrustManager.checkServerTrusted(chain, authType);
            }
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized X509Certificate @UnknownKeyFor @NonNull @Initialized [] getAcceptedIssuers() {
        if (this.defaultTrustManager != null) {
            return this.defaultTrustManager.getAcceptedIssuers();
        }
        return new X509Certificate[0];
    }
}

