/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import com.google.auto.value.AutoValue;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.splunk.AutoValue_SplunkIO_Write;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.sdk.io.splunk.SplunkEventWriter;
import org.apache.beam.sdk.io.splunk.SplunkWriteError;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SplunkIO {
    private static final Logger LOG = LoggerFactory.getLogger(SplunkIO.class);

    public static Write write(String url, String token) {
        Preconditions.checkNotNull((Object)url, (Object)"url is required.");
        Preconditions.checkNotNull((Object)token, (Object)"token is required.");
        return SplunkIO.write((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)url), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)token));
    }

    public static Write write(ValueProvider<String> url, ValueProvider<String> token) {
        Preconditions.checkNotNull(url, (Object)"url is required.");
        Preconditions.checkNotNull(token, (Object)"token is required.");
        return new AutoValue_SplunkIO_Write.Builder().setUrl(url).setToken(token).build();
    }

    private SplunkIO() {
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<SplunkEvent>, PCollection<SplunkWriteError>> {
        abstract @Nullable ValueProvider<String> url();

        abstract @Nullable ValueProvider<String> token();

        abstract @Nullable ValueProvider<Integer> batchCount();

        abstract @Nullable ValueProvider<Integer> parallelism();

        abstract @Nullable ValueProvider<Boolean> disableCertificateValidation();

        abstract Builder toBuilder();

        public PCollection<SplunkWriteError> expand(PCollection<SplunkEvent> input) {
            LOG.info("Configuring SplunkEventWriter.");
            SplunkEventWriter.Builder builder = SplunkEventWriter.newBuilder().withUrl(this.url()).withInputBatchCount(this.batchCount()).withDisableCertificateValidation(this.disableCertificateValidation()).withToken(this.token());
            SplunkEventWriter writer = builder.build();
            LOG.info("SplunkEventWriter configured");
            return (PCollection)((PCollection)input.apply("Create KV pairs", (PTransform)CreateKeys.of(this.parallelism()))).apply("Write Splunk events", (PTransform)ParDo.of((DoFn)writer));
        }

        public Write withBatchCount(ValueProvider<Integer> batchCount) {
            Preconditions.checkArgument((batchCount != null ? 1 : 0) != 0, (Object)"withBatchCount(batchCount) called with null input.");
            return this.toBuilder().setBatchCount(batchCount).build();
        }

        public Write withBatchCount(Integer batchCount) {
            Preconditions.checkArgument((batchCount != null ? 1 : 0) != 0, (Object)"withBatchCount(batchCount) called with null input.");
            return this.toBuilder().setBatchCount((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)batchCount)).build();
        }

        public Write withParallelism(ValueProvider<Integer> parallelism) {
            Preconditions.checkArgument((parallelism != null ? 1 : 0) != 0, (Object)"withParallelism(parallelism) called with null input.");
            return this.toBuilder().setParallelism(parallelism).build();
        }

        public Write withParallelism(Integer parallelism) {
            Preconditions.checkArgument((parallelism != null ? 1 : 0) != 0, (Object)"withParallelism(parallelism) called with null input.");
            return this.toBuilder().setParallelism((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)parallelism)).build();
        }

        public Write withDisableCertificateValidation(ValueProvider<Boolean> disableCertificateValidation) {
            Preconditions.checkArgument((disableCertificateValidation != null ? 1 : 0) != 0, (Object)"withDisableCertificateValidation(disableCertificateValidation) called with null input.");
            return this.toBuilder().setDisableCertificateValidation(disableCertificateValidation).build();
        }

        public Write withDisableCertificateValidation(Boolean disableCertificateValidation) {
            Preconditions.checkArgument((disableCertificateValidation != null ? 1 : 0) != 0, (Object)"withDisableCertificateValidation(disableCertificateValidation) called with null input.");
            return this.toBuilder().setDisableCertificateValidation((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)disableCertificateValidation)).build();
        }

        private static class CreateKeys
        extends PTransform<PCollection<SplunkEvent>, PCollection<KV<Integer, SplunkEvent>>> {
            private static final Integer DEFAULT_PARALLELISM = 1;
            private ValueProvider<Integer> requestedKeys;

            private CreateKeys(ValueProvider<Integer> requestedKeys) {
                this.requestedKeys = requestedKeys;
            }

            static CreateKeys of(ValueProvider<Integer> requestedKeys) {
                return new CreateKeys(requestedKeys);
            }

            public PCollection<KV<Integer, SplunkEvent>> expand(PCollection<SplunkEvent> input) {
                return (PCollection)input.apply("Inject Keys", (PTransform)ParDo.of((DoFn)new CreateKeysFn(this.requestedKeys)));
            }

            private static class CreateKeysFn
            extends DoFn<SplunkEvent, KV<Integer, SplunkEvent>> {
                private ValueProvider<Integer> specifiedParallelism;
                private Integer calculatedParallelism;

                CreateKeysFn(ValueProvider<Integer> specifiedParallelism) {
                    this.specifiedParallelism = specifiedParallelism;
                }

                @DoFn.Setup
                public void setup() {
                    if (this.calculatedParallelism == null) {
                        if (this.specifiedParallelism != null) {
                            this.calculatedParallelism = (Integer)this.specifiedParallelism.get();
                        }
                        this.calculatedParallelism = (Integer)MoreObjects.firstNonNull((Object)this.calculatedParallelism, (Object)DEFAULT_PARALLELISM);
                        LOG.info("Parallelism set to: {}", (Object)this.calculatedParallelism);
                    }
                }

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                    context.output((Object)KV.of((Object)ThreadLocalRandom.current().nextInt(this.calculatedParallelism), (Object)((SplunkEvent)context.element())));
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setUrl(ValueProvider<String> var1);

            abstract Builder setToken(ValueProvider<String> var1);

            abstract Builder setBatchCount(ValueProvider<Integer> var1);

            abstract Builder setParallelism(ValueProvider<Integer> var1);

            abstract Builder setDisableCertificateValidation(ValueProvider<Boolean> var1);

            abstract Write build();
        }
    }
}

