/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.splunk.AutoValue_SplunkEventWriter;
import org.apache.beam.sdk.io.splunk.HttpEventPublisher;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.sdk.io.splunk.SplunkWriteError;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
abstract class SplunkEventWriter
extends DoFn<KV<Integer, SplunkEvent>, SplunkWriteError> {
    private static final Integer DEFAULT_BATCH_COUNT = 1;
    private static final Boolean DEFAULT_DISABLE_CERTIFICATE_VALIDATION = false;
    private static final Logger LOG = LoggerFactory.getLogger(SplunkEventWriter.class);
    private static final long DEFAULT_FLUSH_DELAY = 2L;
    private static final Counter INPUT_COUNTER = Metrics.counter(SplunkEventWriter.class, (String)"inbound-events");
    private static final Counter SUCCESS_WRITES = Metrics.counter(SplunkEventWriter.class, (String)"outbound-successful-events");
    private static final Counter FAILED_WRITES = Metrics.counter(SplunkEventWriter.class, (String)"outbound-failed-events");
    private static final String BUFFER_STATE_NAME = "buffer";
    private static final String COUNT_STATE_NAME = "count";
    private static final String TIME_ID_NAME = "expiry";
    @DoFn.StateId(value="buffer")
    private final StateSpec<BagState<SplunkEvent>> buffer = StateSpecs.bag();
    @DoFn.StateId(value="count")
    private final StateSpec<ValueState<Long>> count = StateSpecs.value();
    @DoFn.TimerId(value="expiry")
    private final TimerSpec expirySpec = TimerSpecs.timer((TimeDomain)TimeDomain.PROCESSING_TIME);
    private Integer batchCount;
    private Boolean disableValidation;
    private HttpEventPublisher publisher;
    private static final Gson GSON = new GsonBuilder().setFieldNamingStrategy(f -> f.getName().toLowerCase()).create();

    SplunkEventWriter() {
    }

    static Builder newBuilder() {
        return new AutoValue_SplunkEventWriter.Builder();
    }

    abstract @Nullable ValueProvider<String> url();

    abstract @Nullable ValueProvider<String> token();

    abstract @Nullable ValueProvider<Boolean> disableCertificateValidation();

    abstract @Nullable ValueProvider<Integer> inputBatchCount();

    @DoFn.Setup
    public void setup() {
        Preconditions.checkArgument((boolean)this.url().isAccessible(), (Object)"url is required for writing events.");
        Preconditions.checkArgument((boolean)this.token().isAccessible(), (Object)"Access token is required for writing events.");
        if (this.batchCount == null) {
            if (this.inputBatchCount() != null) {
                this.batchCount = (Integer)this.inputBatchCount().get();
            }
            this.batchCount = (Integer)MoreObjects.firstNonNull((Object)this.batchCount, (Object)DEFAULT_BATCH_COUNT);
            LOG.info("Batch count set to: {}", (Object)this.batchCount);
        }
        if (this.disableValidation == null) {
            if (this.disableCertificateValidation() != null) {
                this.disableValidation = (Boolean)this.disableCertificateValidation().get();
            }
            this.disableValidation = (Boolean)MoreObjects.firstNonNull((Object)this.disableValidation, (Object)DEFAULT_DISABLE_CERTIFICATE_VALIDATION);
            LOG.info("Disable certificate validation set to: {}", (Object)this.disableValidation);
        }
        try {
            HttpEventPublisher.Builder builder = HttpEventPublisher.newBuilder().withUrl((String)this.url().get()).withToken((String)this.token().get()).withDisableCertificateValidation(this.disableValidation);
            this.publisher = builder.build();
            LOG.info("Successfully created HttpEventPublisher");
        }
        catch (UnsupportedEncodingException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            LOG.error("Error creating HttpEventPublisher: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element KV<Integer, SplunkEvent> input, DoFn.OutputReceiver<SplunkWriteError> receiver, BoundedWindow window, @DoFn.StateId(value="buffer") BagState<SplunkEvent> bufferState, @DoFn.StateId(value="count") ValueState<Long> countState, @DoFn.TimerId(value="expiry") Timer timer) throws IOException {
        Long count = (Long)MoreObjects.firstNonNull((Object)((Long)countState.read()), (Object)0L);
        SplunkEvent event = (SplunkEvent)input.getValue();
        INPUT_COUNTER.inc();
        bufferState.add((Object)event);
        count = count + 1L;
        countState.write((Object)count);
        timer.offset(Duration.standardSeconds((long)2L)).setRelative();
        if (count >= (long)this.batchCount.intValue()) {
            LOG.info("Flushing batch of {} events", (Object)count);
            this.flush(receiver, bufferState, countState);
        }
    }

    @DoFn.OnTimer(value="expiry")
    public void onExpiry(DoFn.OutputReceiver<SplunkWriteError> receiver, @DoFn.StateId(value="buffer") BagState<SplunkEvent> bufferState, @DoFn.StateId(value="count") ValueState<Long> countState) throws IOException {
        if ((Long)MoreObjects.firstNonNull((Object)((Long)countState.read()), (Object)0L) > 0L) {
            LOG.info("Flushing window with {} events", countState.read());
            this.flush(receiver, bufferState, countState);
        }
    }

    @DoFn.Teardown
    public void tearDown() {
        if (this.publisher != null) {
            try {
                this.publisher.close();
                LOG.info("Successfully closed HttpEventPublisher");
            }
            catch (IOException e) {
                LOG.warn("Received exception while closing HttpEventPublisher: {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(DoFn.OutputReceiver<SplunkWriteError> receiver, BagState<SplunkEvent> bufferState, ValueState<Long> countState) throws IOException {
        if (!((Boolean)bufferState.isEmpty().read()).booleanValue()) {
            HttpResponse response = null;
            ArrayList events = Lists.newArrayList((Iterable)bufferState.read());
            try {
                response = this.publisher.execute(events);
                if (!response.isSuccessStatusCode()) {
                    SplunkEventWriter.flushWriteFailures(events, response.getStatusMessage(), response.getStatusCode(), receiver);
                    this.logWriteFailures(countState);
                } else {
                    LOG.info("Successfully wrote {} events", countState.read());
                    SUCCESS_WRITES.inc(((Long)countState.read()).longValue());
                }
            }
            catch (HttpResponseException e) {
                LOG.error("Error writing to Splunk. StatusCode: {}, content: {}, StatusMessage: {}", new Object[]{e.getStatusCode(), e.getContent(), e.getStatusMessage()});
                this.logWriteFailures(countState);
                SplunkEventWriter.flushWriteFailures(events, e.getStatusMessage(), e.getStatusCode(), receiver);
            }
            catch (IOException ioe) {
                LOG.error("Error writing to Splunk: {}", (Object)ioe.getMessage());
                this.logWriteFailures(countState);
                SplunkEventWriter.flushWriteFailures(events, ioe.getMessage(), null, receiver);
            }
            finally {
                bufferState.clear();
                countState.clear();
                if (response != null) {
                    response.disconnect();
                }
            }
        }
    }

    private void logWriteFailures(@DoFn.StateId(value="count") ValueState<Long> countState) {
        LOG.error("Failed to write {} events", countState.read());
        FAILED_WRITES.inc(((Long)countState.read()).longValue());
    }

    private static void flushWriteFailures(List<SplunkEvent> events, String statusMessage, Integer statusCode, DoFn.OutputReceiver<SplunkWriteError> receiver) {
        Preconditions.checkNotNull(events, (Object)"events cannot be null.");
        SplunkWriteError.Builder builder = SplunkWriteError.newBuilder();
        if (statusMessage != null) {
            builder.withStatusMessage(statusMessage);
        }
        if (statusCode != null) {
            builder.withStatusCode(statusCode);
        }
        for (SplunkEvent event : events) {
            String payload = GSON.toJson((Object)event);
            SplunkWriteError error = builder.withPayload(payload).create();
            receiver.output((Object)error);
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setUrl(ValueProvider<String> var1);

        abstract ValueProvider<String> url();

        abstract Builder setToken(ValueProvider<String> var1);

        abstract ValueProvider<String> token();

        abstract Builder setDisableCertificateValidation(ValueProvider<Boolean> var1);

        abstract Builder setInputBatchCount(ValueProvider<Integer> var1);

        abstract SplunkEventWriter autoBuild();

        Builder withUrl(ValueProvider<String> url) {
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"withURL(url) called with null input.");
            return this.setUrl(url);
        }

        Builder withUrl(String url) {
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"withURL(url) called with null input.");
            return this.setUrl((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)url));
        }

        Builder withToken(ValueProvider<String> token) {
            Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"withToken(token) called with null input.");
            return this.setToken(token);
        }

        Builder withToken(String token) {
            Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"withToken(token) called with null input.");
            return this.setToken((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)token));
        }

        Builder withInputBatchCount(ValueProvider<Integer> inputBatchCount) {
            return this.setInputBatchCount(inputBatchCount);
        }

        Builder withDisableCertificateValidation(ValueProvider<Boolean> disableCertificateValidation) {
            return this.setDisableCertificateValidation(disableCertificateValidation);
        }

        SplunkEventWriter build() {
            Preconditions.checkNotNull(this.url(), (Object)"url needs to be provided.");
            Preconditions.checkNotNull(this.token(), (Object)"token needs to be provided.");
            return this.autoBuild();
        }
    }
}

