/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import com.google.auto.value.AutoValue;
import com.google.gson.annotations.SerializedName;
import org.apache.beam.sdk.io.splunk.AutoValue_SplunkEvent;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class SplunkEvent {
    public static Builder newBuilder() {
        return new AutoValue_SplunkEvent.Builder();
    }

    public abstract @Nullable Long time();

    public abstract @Nullable String host();

    public abstract @Nullable String source();

    @SerializedName(value="sourcetype")
    public abstract @Nullable String sourceType();

    public abstract @Nullable String index();

    public abstract @Nullable String event();

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setTime(Long var1);

        abstract Builder setHost(String var1);

        abstract Builder setSource(String var1);

        abstract Builder setSourceType(String var1);

        abstract Builder setIndex(String var1);

        abstract Builder setEvent(String var1);

        abstract String event();

        abstract SplunkEvent build();

        public Builder withTime(Long time) {
            Preconditions.checkNotNull((Object)time, (Object)"withTime(time) called with null input.");
            return this.setTime(time);
        }

        public Builder withHost(String host) {
            Preconditions.checkNotNull((Object)host, (Object)"withHost(host) called with null input.");
            return this.setHost(host);
        }

        public Builder withSource(String source) {
            Preconditions.checkNotNull((Object)source, (Object)"withSource(source) called with null input.");
            return this.setSource(source);
        }

        public Builder withSourceType(String sourceType) {
            Preconditions.checkNotNull((Object)sourceType, (Object)"withSourceType(sourceType) called with null input.");
            return this.setSourceType(sourceType);
        }

        public Builder withIndex(String index) {
            Preconditions.checkNotNull((Object)index, (Object)"withIndex(index) called with null input.");
            return this.setIndex(index);
        }

        public Builder withEvent(String event) {
            Preconditions.checkNotNull((Object)event, (Object)"withEvent(event) called with null input.");
            return this.setEvent(event);
        }

        public SplunkEvent create() {
            Preconditions.checkNotNull((Object)this.event(), (Object)"Event information is required.");
            return this.build();
        }
    }
}

