/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.beam.sdk.io.splunk.AutoValue_HttpEventPublisher;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
abstract class HttpEventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEventPublisher.class);
    private static final int DEFAULT_MAX_CONNECTIONS = 1;
    private static final boolean DEFAULT_DISABLE_CERTIFICATE_VALIDATION = false;
    private static final Gson GSON = new GsonBuilder().setFieldNamingStrategy(f -> f.getName().toLowerCase()).create();
    @VisibleForTesting
    static final String HEC_URL_PATH = "services/collector/event";
    private static final HttpMediaType MEDIA_TYPE = new HttpMediaType("application/json;profile=urn:splunk:event:1.0;charset=utf-8");
    private static final String CONTENT_TYPE = Joiner.on((char)'/').join((Object)MEDIA_TYPE.getType(), (Object)MEDIA_TYPE.getSubType(), new Object[0]);
    private static final String AUTHORIZATION_SCHEME = "Splunk %s";
    private static final String HTTPS_PROTOCOL_PREFIX = "https";

    HttpEventPublisher() {
    }

    static Builder newBuilder() {
        return new AutoValue_HttpEventPublisher.Builder();
    }

    abstract ApacheHttpTransport transport();

    abstract HttpRequestFactory requestFactory();

    abstract GenericUrl genericUrl();

    abstract String token();

    abstract @Nullable Integer maxElapsedMillis();

    abstract Boolean disableCertificateValidation();

    HttpResponse execute(List<SplunkEvent> events) throws IOException {
        HttpContent content = this.getContent(events);
        HttpRequest request = this.requestFactory().buildPostRequest(this.genericUrl(), content);
        HttpBackOffUnsuccessfulResponseHandler responseHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)this.getConfiguredBackOff());
        responseHandler.setBackOffRequired(HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ON_SERVER_ERROR);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)responseHandler);
        this.setHeaders(request, this.token());
        return request.execute();
    }

    HttpResponse execute(SplunkEvent event) throws IOException {
        return this.execute((List<SplunkEvent>)ImmutableList.of((Object)event));
    }

    @VisibleForTesting
    ExponentialBackOff getConfiguredBackOff() {
        return new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(this.maxElapsedMillis().intValue()).build();
    }

    void close() throws IOException {
        if (this.transport() != null) {
            LOG.info("Closing publisher transport.");
            this.transport().shutdown();
        }
    }

    private void setHeaders(HttpRequest request, String token) {
        request.getHeaders().setAuthorization(String.format(AUTHORIZATION_SCHEME, token));
    }

    @VisibleForTesting
    HttpContent getContent(List<SplunkEvent> events) {
        String payload = this.getStringPayload(events);
        LOG.debug("Payload content: {}", (Object)payload);
        return ByteArrayContent.fromString((String)CONTENT_TYPE, (String)payload);
    }

    @VisibleForTesting
    String getStringPayload(List<SplunkEvent> events) {
        StringBuilder sb = new StringBuilder();
        events.forEach(event -> sb.append(GSON.toJson(event)));
        return sb.toString();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setTransport(ApacheHttpTransport var1);

        abstract ApacheHttpTransport transport();

        abstract Builder setRequestFactory(HttpRequestFactory var1);

        abstract Builder setGenericUrl(GenericUrl var1);

        abstract GenericUrl genericUrl();

        abstract Builder setToken(String var1);

        abstract String token();

        abstract Builder setDisableCertificateValidation(Boolean var1);

        abstract Boolean disableCertificateValidation();

        abstract Builder setMaxElapsedMillis(Integer var1);

        abstract Integer maxElapsedMillis();

        abstract HttpEventPublisher autoBuild();

        Builder withUrl(String url) throws UnsupportedEncodingException {
            Preconditions.checkNotNull((Object)url, (Object)"withUrl(url) called with null input.");
            return this.setGenericUrl(this.getGenericUrl(url));
        }

        Builder withToken(String token) {
            Preconditions.checkNotNull((Object)token, (Object)"withToken(token) called with null input.");
            return this.setToken(token);
        }

        Builder withDisableCertificateValidation(Boolean disableCertificateValidation) {
            Preconditions.checkNotNull((Object)disableCertificateValidation, (Object)"withDisableCertificateValidation(disableCertificateValidation) called with null input.");
            return this.setDisableCertificateValidation(disableCertificateValidation);
        }

        Builder withMaxElapsedMillis(Integer maxElapsedMillis) {
            Preconditions.checkNotNull((Object)maxElapsedMillis, (Object)"withMaxElapsedMillis(maxElapsedMillis) called with null input.");
            return this.setMaxElapsedMillis(maxElapsedMillis);
        }

        HttpEventPublisher build() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
            Preconditions.checkNotNull((Object)this.token(), (Object)"Authentication token needs to be specified via withToken(token).");
            Preconditions.checkNotNull((Object)this.genericUrl(), (Object)"URL needs to be specified via withUrl(url).");
            if (this.disableCertificateValidation() == null) {
                LOG.info("Certificate validation disabled: {}", (Object)false);
                this.setDisableCertificateValidation(false);
            }
            if (this.maxElapsedMillis() == null) {
                LOG.info("Defaulting max backoff time to: {} milliseconds ", (Object)900000);
                this.setMaxElapsedMillis(900000);
            }
            CloseableHttpClient httpClient = this.getHttpClient(1, this.disableCertificateValidation());
            this.setTransport(new ApacheHttpTransport((HttpClient)httpClient));
            this.setRequestFactory(this.transport().createRequestFactory());
            return this.autoBuild();
        }

        GenericUrl getGenericUrl(String baseUrl) {
            String url = Joiner.on((char)'/').join((Object)baseUrl, (Object)HttpEventPublisher.HEC_URL_PATH, new Object[0]);
            return new GenericUrl(url);
        }

        private CloseableHttpClient getHttpClient(int maxConnections, boolean disableCertificateValidation) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
            HttpClientBuilder builder = ApacheHttpTransport.newDefaultHttpClientBuilder();
            if (this.genericUrl().getScheme().equalsIgnoreCase(HttpEventPublisher.HTTPS_PROTOCOL_PREFIX)) {
                LOG.info("SSL connection requested");
                NoopHostnameVerifier hostnameVerifier = disableCertificateValidation ? NoopHostnameVerifier.INSTANCE : new DefaultHostnameVerifier();
                SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
                if (disableCertificateValidation) {
                    LOG.info("Certificate validation is disabled");
                    sslContextBuilder.loadTrustMaterial((org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true));
                }
                SSLConnectionSocketFactory connectionSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)hostnameVerifier);
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)connectionSocketFactory);
            }
            builder.setMaxConnTotal(maxConnections);
            builder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
            return builder.build();
        }
    }
}

