/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.sdk.io.splunk.SplunkIO;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.VerificationTimes;

public class SplunkIOTest {
    private static final String EXPECTED_PATH = "/services/collector/event";
    private static final long MAX_SOCKET_TIMEOUT_MILLIS = 180000L;
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public MockServerRule mockServerRule = new MockServerRule((Object)this);
    private MockServerClient mockServerClient;

    @BeforeClass
    public static void setup() {
        ConfigurationProperties.maxSocketTimeout((long)180000L);
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void successfulSplunkIOMultiBatchNoParallelismTest() {
        this.mockServerListening(200);
        int testPort = this.mockServerRule.getPort();
        String url = Joiner.on((char)':').join((Object)"http://localhost", (Object)testPort, new Object[0]);
        String token = "test-token";
        ImmutableList testEvents = ImmutableList.of((Object)SplunkEvent.newBuilder().withEvent("test-event-1").withHost("test-host-1").withIndex("test-index-1").withSource("test-source-1").withSourceType("test-source-type-1").withTime(Long.valueOf(12345L)).create(), (Object)SplunkEvent.newBuilder().withEvent("test-event-2").withHost("test-host-2").withIndex("test-index-2").withSource("test-source-2").withSourceType("test-source-type-2").withTime(Long.valueOf(12345L)).create());
        PCollection actual = (PCollection)((PCollection)this.pipeline.apply("Create Input data", (PTransform)Create.of((Iterable)testEvents))).apply("SplunkIO", (PTransform)SplunkIO.write((String)url, (String)token).withParallelism(Integer.valueOf(1)).withBatchCount(Integer.valueOf(testEvents.size())));
        PAssert.that((PCollection)actual).empty();
        this.pipeline.run();
        this.mockServerClient.verify(HttpRequest.request((String)EXPECTED_PATH), VerificationTimes.once());
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void successfulSplunkIOMultiBatchParallelismTest() {
        this.mockServerListening(200);
        int testPort = this.mockServerRule.getPort();
        int testParallelism = 2;
        String url = Joiner.on((char)':').join((Object)"http://localhost", (Object)testPort, new Object[0]);
        String token = "test-token";
        ImmutableList testEvents = ImmutableList.of((Object)SplunkEvent.newBuilder().withEvent("test-event-1").withHost("test-host-1").withIndex("test-index-1").withSource("test-source-1").withSourceType("test-source-type-1").withTime(Long.valueOf(12345L)).create(), (Object)SplunkEvent.newBuilder().withEvent("test-event-2").withHost("test-host-2").withIndex("test-index-2").withSource("test-source-2").withSourceType("test-source-type-2").withTime(Long.valueOf(12345L)).create());
        PCollection actual = (PCollection)((PCollection)this.pipeline.apply("Create Input data", (PTransform)Create.of((Iterable)testEvents))).apply("SplunkIO", (PTransform)SplunkIO.write((String)url, (String)token).withParallelism(Integer.valueOf(testParallelism)).withBatchCount(Integer.valueOf(testEvents.size())));
        PAssert.that((PCollection)actual).empty();
        this.pipeline.run();
        this.mockServerClient.verify(HttpRequest.request((String)EXPECTED_PATH), VerificationTimes.atMost((int)testParallelism));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void successfulSplunkIOSingleBatchParallelismTest() {
        this.mockServerListening(200);
        int testPort = this.mockServerRule.getPort();
        int testParallelism = 2;
        String url = Joiner.on((char)':').join((Object)"http://localhost", (Object)testPort, new Object[0]);
        String token = "test-token";
        ImmutableList testEvents = ImmutableList.of((Object)SplunkEvent.newBuilder().withEvent("test-event-1").withHost("test-host-1").withIndex("test-index-1").withSource("test-source-1").withSourceType("test-source-type-1").withTime(Long.valueOf(12345L)).create(), (Object)SplunkEvent.newBuilder().withEvent("test-event-2").withHost("test-host-2").withIndex("test-index-2").withSource("test-source-2").withSourceType("test-source-type-2").withTime(Long.valueOf(12345L)).create());
        PCollection actual = (PCollection)((PCollection)this.pipeline.apply("Create Input data", (PTransform)Create.of((Iterable)testEvents))).apply("SplunkIO", (PTransform)SplunkIO.write((String)url, (String)token).withParallelism(Integer.valueOf(testParallelism)).withBatchCount(Integer.valueOf(1)));
        PAssert.that((PCollection)actual).empty();
        this.pipeline.run();
        this.mockServerClient.verify(HttpRequest.request((String)EXPECTED_PATH), VerificationTimes.exactly((int)testEvents.size()));
    }

    private void mockServerListening(int statusCode) {
        this.mockServerClient.when(HttpRequest.request((String)EXPECTED_PATH)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(statusCode)));
    }
}

