/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.sdk.io.splunk.SplunkEventWriter;
import org.apache.beam.sdk.io.splunk.SplunkWriteError;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.Assertions;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.VerificationTimes;

public class SplunkEventWriterTest {
    private static final String EXPECTED_PATH = "/services/collector/event";
    private static final long MAX_SOCKET_TIMEOUT_MILLIS = 180000L;
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public MockServerRule mockServerRule = new MockServerRule((Object)this);
    private MockServerClient mockServerClient;

    @BeforeClass
    public static void setup() {
        ConfigurationProperties.maxSocketTimeout((long)180000L);
    }

    @Test
    public void eventWriterMissingURL() {
        Exception thrown = (Exception)Assertions.assertThrows(NullPointerException.class, () -> SplunkEventWriter.newBuilder().build());
        Assert.assertTrue((boolean)thrown.getMessage().contains("url needs to be provided"));
    }

    @Test
    public void eventWriterMissingToken() {
        Exception thrown = (Exception)Assertions.assertThrows(NullPointerException.class, () -> SplunkEventWriter.newBuilder().withUrl("test-url").build());
        Assert.assertTrue((boolean)thrown.getMessage().contains("token needs to be provided"));
    }

    @Test
    public void eventWriterDefaultBatchCountAndValidation() {
        SplunkEventWriter writer = SplunkEventWriter.newBuilder().withUrl("test-url").withToken("test-token").build();
        Assert.assertNull((Object)writer.inputBatchCount());
        Assert.assertNull((Object)writer.disableCertificateValidation());
    }

    @Test
    public void eventWriterCustomBatchCountAndValidation() {
        Integer batchCount = 30;
        Boolean certificateValidation = false;
        SplunkEventWriter writer = SplunkEventWriter.newBuilder().withUrl("test-url").withToken("test-token").withInputBatchCount((ValueProvider)ValueProvider.StaticValueProvider.of((Object)batchCount)).withDisableCertificateValidation((ValueProvider)ValueProvider.StaticValueProvider.of((Object)certificateValidation)).build();
        Assert.assertEquals((Object)batchCount, (Object)writer.inputBatchCount().get());
        Assert.assertEquals((Object)certificateValidation, (Object)writer.disableCertificateValidation().get());
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void successfulSplunkWriteSingleBatchTest() {
        this.mockServerListening(200);
        int testPort = this.mockServerRule.getPort();
        ImmutableList testEvents = ImmutableList.of((Object)KV.of((Object)123, (Object)SplunkEvent.newBuilder().withEvent("test-event-1").withHost("test-host-1").withIndex("test-index-1").withSource("test-source-1").withSourceType("test-source-type-1").withTime(Long.valueOf(12345L)).create()), (Object)KV.of((Object)123, (Object)SplunkEvent.newBuilder().withEvent("test-event-2").withHost("test-host-2").withIndex("test-index-2").withSource("test-source-2").withSourceType("test-source-type-2").withTime(Long.valueOf(12345L)).create()));
        PCollection actual = (PCollection)((PCollection)this.pipeline.apply("Create Input data", (PTransform)Create.of((Iterable)testEvents))).apply("SplunkEventWriter", (PTransform)ParDo.of((DoFn)SplunkEventWriter.newBuilder().withUrl(Joiner.on((char)':').join((Object)"http://localhost", (Object)testPort, new Object[0])).withInputBatchCount((ValueProvider)ValueProvider.StaticValueProvider.of((Object)1)).withToken("test-token").build()));
        PAssert.that((PCollection)actual).empty();
        this.pipeline.run();
        this.mockServerClient.verify(HttpRequest.request((String)EXPECTED_PATH), VerificationTimes.exactly((int)testEvents.size()));
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void successfulSplunkWriteMultiBatchTest() {
        this.mockServerListening(200);
        int testPort = this.mockServerRule.getPort();
        ImmutableList testEvents = ImmutableList.of((Object)KV.of((Object)123, (Object)SplunkEvent.newBuilder().withEvent("test-event-1").withHost("test-host-1").withIndex("test-index-1").withSource("test-source-1").withSourceType("test-source-type-1").withTime(Long.valueOf(12345L)).create()), (Object)KV.of((Object)123, (Object)SplunkEvent.newBuilder().withEvent("test-event-2").withHost("test-host-2").withIndex("test-index-2").withSource("test-source-2").withSourceType("test-source-type-2").withTime(Long.valueOf(12345L)).create()));
        PCollection actual = (PCollection)((PCollection)this.pipeline.apply("Create Input data", (PTransform)Create.of((Iterable)testEvents))).apply("SplunkEventWriter", (PTransform)ParDo.of((DoFn)SplunkEventWriter.newBuilder().withUrl(Joiner.on((char)':').join((Object)"http://localhost", (Object)testPort, new Object[0])).withInputBatchCount((ValueProvider)ValueProvider.StaticValueProvider.of((Object)testEvents.size())).withToken("test-token").build()));
        PAssert.that((PCollection)actual).empty();
        this.pipeline.run();
        this.mockServerClient.verify(HttpRequest.request((String)EXPECTED_PATH), VerificationTimes.once());
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void failedSplunkWriteSingleBatchTest() {
        this.mockServerListening(404);
        int testPort = this.mockServerRule.getPort();
        ImmutableList testEvents = ImmutableList.of((Object)KV.of((Object)123, (Object)SplunkEvent.newBuilder().withEvent("test-event-1").withHost("test-host-1").withIndex("test-index-1").withSource("test-source-1").withSourceType("test-source-type-1").withTime(Long.valueOf(12345L)).create()));
        PCollection actual = (PCollection)((PCollection)this.pipeline.apply("Create Input data", (PTransform)Create.of((Iterable)testEvents))).apply("SplunkEventWriter", (PTransform)ParDo.of((DoFn)SplunkEventWriter.newBuilder().withUrl(Joiner.on((char)':').join((Object)"http://localhost", (Object)testPort, new Object[0])).withInputBatchCount((ValueProvider)ValueProvider.StaticValueProvider.of((Object)testEvents.size())).withToken("test-token").build()));
        PAssert.that((PCollection)actual).containsInAnyOrder((Object[])new SplunkWriteError[]{SplunkWriteError.newBuilder().withStatusCode(Integer.valueOf(404)).withStatusMessage("Not Found").withPayload("{\"time\":12345,\"host\":\"test-host-1\",\"source\":\"test-source-1\",\"sourcetype\":\"test-source-type-1\",\"index\":\"test-index-1\",\"event\":\"test-event-1\"}").create()});
        this.pipeline.run();
        this.mockServerClient.verify(HttpRequest.request((String)EXPECTED_PATH), VerificationTimes.once());
    }

    private void mockServerListening(int statusCode) {
        this.mockServerClient.when(HttpRequest.request((String)EXPECTED_PATH)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(statusCode)));
    }
}

