/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.beam.sdk.io.splunk.HttpEventPublisher;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;

public class HttpEventPublisherTest {
    private static final SplunkEvent SPLUNK_TEST_EVENT_1 = SplunkEvent.newBuilder().withEvent("test-event-1").withHost("test-host-1").withIndex("test-index-1").withSource("test-source-1").withSourceType("test-source-type-1").withTime(Long.valueOf(12345L)).create();
    private static final SplunkEvent SPLUNK_TEST_EVENT_2 = SplunkEvent.newBuilder().withEvent("test-event-2").withHost("test-host-2").withIndex("test-index-2").withSource("test-source-2").withSourceType("test-source-type-2").withTime(Long.valueOf(12345L)).create();
    private static final ImmutableList<SplunkEvent> SPLUNK_EVENTS = ImmutableList.of((Object)SPLUNK_TEST_EVENT_1, (Object)SPLUNK_TEST_EVENT_2);

    @Test
    public void stringPayloadTest() throws UnsupportedEncodingException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HttpEventPublisher publisher = HttpEventPublisher.newBuilder().withUrl("http://example.com").withToken("test-token").withDisableCertificateValidation(Boolean.valueOf(false)).build();
        String actual = publisher.getStringPayload(SPLUNK_EVENTS);
        String expected = "{\"time\":12345,\"host\":\"test-host-1\",\"source\":\"test-source-1\",\"sourcetype\":\"test-source-type-1\",\"index\":\"test-index-1\",\"event\":\"test-event-1\"}{\"time\":12345,\"host\":\"test-host-2\",\"source\":\"test-source-2\",\"sourcetype\":\"test-source-type-2\",\"index\":\"test-index-2\",\"event\":\"test-event-2\"}";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void contentTest() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        HttpEventPublisher publisher = HttpEventPublisher.newBuilder().withUrl("http://example.com").withToken("test-token").withDisableCertificateValidation(Boolean.valueOf(false)).build();
        String expectedString = "{\"time\":12345,\"host\":\"test-host-1\",\"source\":\"test-source-1\",\"sourcetype\":\"test-source-type-1\",\"index\":\"test-index-1\",\"event\":\"test-event-1\"}{\"time\":12345,\"host\":\"test-host-2\",\"source\":\"test-source-2\",\"sourcetype\":\"test-source-type-2\",\"index\":\"test-index-2\",\"event\":\"test-event-2\"}";
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            HttpContent actualContent = publisher.getContent(SPLUNK_EVENTS);
            actualContent.writeTo((OutputStream)bos);
            String actualString = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            Assert.assertEquals((Object)expectedString, (Object)actualString);
        }
    }

    @Test
    public void genericURLTest() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        String baseURL = "http://example.com";
        HttpEventPublisher.Builder builder = HttpEventPublisher.newBuilder().withUrl(baseURL).withToken("test-token").withDisableCertificateValidation(Boolean.valueOf(false));
        Assert.assertEquals((Object)new GenericUrl(Joiner.on((char)'/').join((Object)baseURL, (Object)"services/collector/event", new Object[0])), (Object)builder.genericUrl());
    }

    @Test
    public void configureBackOffDefaultTest() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        HttpEventPublisher publisherDefaultBackOff = HttpEventPublisher.newBuilder().withUrl("http://example.com").withToken("test-token").withDisableCertificateValidation(Boolean.valueOf(false)).build();
        Assert.assertEquals((long)900000L, (long)publisherDefaultBackOff.getConfiguredBackOff().getMaxElapsedTimeMillis());
    }

    @Test
    public void configureBackOffCustomTest() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException {
        int timeoutInMillis = 600000;
        HttpEventPublisher publisherWithBackOff = HttpEventPublisher.newBuilder().withUrl("http://example.com").withToken("test-token").withDisableCertificateValidation(Boolean.valueOf(false)).withMaxElapsedMillis(Integer.valueOf(timeoutInMillis)).build();
        Assert.assertEquals((long)timeoutInMillis, (long)publisherWithBackOff.getConfiguredBackOff().getMaxElapsedTimeMillis());
    }
}

