/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.sparkreceiver;

import java.nio.ByteBuffer;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.spark.SparkConf;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;

public class WrappedSupervisor
extends ReceiverSupervisor {
    private final SerializableFunction<Object[], Void> storeFn;

    public WrappedSupervisor(Receiver<?> receiver, SparkConf conf, SerializableFunction<Object[], Void> storeFn) {
        super(receiver, conf);
        this.storeFn = storeFn;
    }

    public void pushSingle(Object o) {
        this.storeFn.apply((Object)new Object[]{o});
    }

    public void pushBytes(ByteBuffer byteBuffer, Option<Object> option, Option<StreamBlockId> option1) {
        this.storeFn.apply((Object)new Object[]{byteBuffer, option, option1});
    }

    public void pushIterator(Iterator<?> iterator, Option<Object> option, Option<StreamBlockId> option1) {
        this.storeFn.apply((Object)new Object[]{iterator, option, option1});
    }

    public void pushArrayBuffer(ArrayBuffer<?> arrayBuffer, Option<Object> option, Option<StreamBlockId> option1) {
        this.storeFn.apply((Object)new Object[]{arrayBuffer, option, option1});
    }

    public BlockGenerator createBlockGenerator(BlockGeneratorListener blockGeneratorListener) {
        return null;
    }

    public void reportError(String s, Throwable throwable) {
    }

    public boolean onReceiverStart() {
        return true;
    }

    public long getCurrentRateLimit() {
        return Integer.MAX_VALUE;
    }

    public boolean isReceiverStopped() {
        return super.isReceiverStopped();
    }
}

