/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.sparkreceiver;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.sparkreceiver.HasOffset;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.mutable.ArrayBuffer;

public class ArrayBufferDataReceiver
extends Receiver<String>
implements HasOffset {
    private static final Logger LOG = LoggerFactory.getLogger(ArrayBufferDataReceiver.class);
    private static final int TIMEOUT_MS = 500;
    public static final int RECORDS_COUNT = 20;
    private Long startOffset;

    ArrayBufferDataReceiver() {
        super(StorageLevel.MEMORY_AND_DISK_2());
    }

    public void setStartOffset(Long startOffset) {
        if (startOffset != null) {
            this.startOffset = startOffset;
        }
    }

    public void onStart() {
        Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().build()).submit(this::receive);
    }

    public void onStop() {
    }

    public Long getEndOffset() {
        return Long.MAX_VALUE;
    }

    private void receive() {
        Long currentOffset = this.startOffset;
        while (!this.isStopped() && currentOffset < 20L) {
            ArrayBuffer dataArray = new ArrayBuffer();
            for (int i = 0; i < Math.max(2, 2); ++i) {
                Long l = currentOffset;
                Long l2 = currentOffset = Long.valueOf(currentOffset + 1L);
                dataArray.$plus$eq((Object)String.valueOf(l));
            }
            this.store(dataArray);
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted", (Throwable)e);
            }
        }
    }
}

