/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.sparkreceiver;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.io.sparkreceiver.AutoValue_SparkReceiverIO_Read;
import org.apache.beam.sdk.io.sparkreceiver.HasOffset;
import org.apache.beam.sdk.io.sparkreceiver.ReadFromSparkReceiverWithOffsetDoFn;
import org.apache.beam.sdk.io.sparkreceiver.ReceiverBuilder;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.spark.streaming.receiver.Receiver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkReceiverIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SparkReceiverIO.class);

    public static <V> @UnknownKeyFor @NonNull @Initialized Read<V> read() {
        return new AutoValue_SparkReceiverIO_Read.Builder().build();
    }

    static class ReadFromSparkReceiverViaSdf<@UnknownKeyFor V>
    extends PTransform<PBegin, PCollection<V>> {
        private final @UnknownKeyFor @NonNull @Initialized Read<V> sparkReceiverRead;

        ReadFromSparkReceiverViaSdf(@UnknownKeyFor @NonNull @Initialized Read<V> sparkReceiverRead) {
            this.sparkReceiverRead = sparkReceiverRead;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<V> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            ReceiverBuilder<V, Receiver<V>> sparkReceiverBuilder = this.sparkReceiverRead.getSparkReceiverBuilder();
            Preconditions.checkStateNotNull(sparkReceiverBuilder, (Object)"withSparkReceiverBuilder() is required");
            if (!HasOffset.class.isAssignableFrom(sparkReceiverBuilder.getSparkReceiverClass())) {
                throw new UnsupportedOperationException(String.format("Given Spark Receiver class %s doesn't implement HasOffset interface, therefore it is not supported!", sparkReceiverBuilder.getSparkReceiverClass().getName()));
            }
            LOG.info("{} started reading", (Object)ReadFromSparkReceiverWithOffsetDoFn.class.getSimpleName());
            return (PCollection)((PCollection)input.apply((PTransform)Impulse.create())).apply((PTransform)ParDo.of(new ReadFromSparkReceiverWithOffsetDoFn<V>(this.sparkReceiverRead)));
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Read<@UnknownKeyFor V>
    extends PTransform<PBegin, PCollection<V>> {
        abstract @Nullable @UnknownKeyFor @Initialized ReceiverBuilder<V, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Receiver<V>> getSparkReceiverBuilder();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<V, @UnknownKeyFor @NonNull @Initialized Long> getGetOffsetFn();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<V, @UnknownKeyFor @NonNull @Initialized Instant> getTimestampFn();

        abstract @Nullable @UnknownKeyFor @Initialized Long getPullFrequencySec();

        abstract @Nullable @UnknownKeyFor @Initialized Long getStartPollTimeoutSec();

        abstract @Nullable @UnknownKeyFor @Initialized Long getStartOffset();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<V> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read<V> withSparkReceiverBuilder(@UnknownKeyFor @NonNull @Initialized ReceiverBuilder<V, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Receiver<V>> sparkReceiverBuilder) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((sparkReceiverBuilder != null ? 1 : 0) != 0, (Object)"Spark receiver builder can not be null");
            return this.toBuilder().setSparkReceiverBuilder(sparkReceiverBuilder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<V> withGetOffsetFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<V, @UnknownKeyFor @NonNull @Initialized Long> getOffsetFn) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((getOffsetFn != null ? 1 : 0) != 0, (Object)"Get offset function can not be null");
            return this.toBuilder().setGetOffsetFn(getOffsetFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<V> withTimestampFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<V, @UnknownKeyFor @NonNull @Initialized Instant> timestampFn) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((timestampFn != null ? 1 : 0) != 0, (Object)"Timestamp function can not be null");
            return this.toBuilder().setTimestampFn(timestampFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<V> withPullFrequencySec(@UnknownKeyFor @NonNull @Initialized Long pullFrequencySec) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((pullFrequencySec != null ? 1 : 0) != 0, (Object)"Pull frequency can not be null");
            return this.toBuilder().setPullFrequencySec(pullFrequencySec).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<V> withStartPollTimeoutSec(@UnknownKeyFor @NonNull @Initialized Long startPollTimeoutSec) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((startPollTimeoutSec != null ? 1 : 0) != 0, (Object)"Start poll timeout can not be null");
            return this.toBuilder().setStartPollTimeoutSec(startPollTimeoutSec).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<V> withStartOffset(@UnknownKeyFor @NonNull @Initialized Long startOffset) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((startOffset != null ? 1 : 0) != 0, (Object)"Start offset can not be null");
            return this.toBuilder().setStartOffset(startOffset).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<V> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.validateTransform();
            return (PCollection)input.apply(new ReadFromSparkReceiverViaSdf(this));
        }

        public void validateTransform() {
            ReceiverBuilder<V, Receiver<V>> sparkReceiverBuilder = this.getSparkReceiverBuilder();
            Preconditions.checkStateNotNull(sparkReceiverBuilder, (Object)"withSparkReceiverBuilder() is required");
            Preconditions.checkStateNotNull(this.getGetOffsetFn(), (Object)"withGetOffsetFn() is required");
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor V> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<V> setSparkReceiverBuilder(@UnknownKeyFor @NonNull @Initialized ReceiverBuilder<V, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Receiver<V>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<V> setGetOffsetFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<V, @UnknownKeyFor @NonNull @Initialized Long> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<V> setTimestampFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<V, @UnknownKeyFor @NonNull @Initialized Instant> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<V> setPullFrequencySec(@UnknownKeyFor @NonNull @Initialized Long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<V> setStartPollTimeoutSec(@UnknownKeyFor @NonNull @Initialized Long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<V> setStartOffset(@UnknownKeyFor @NonNull @Initialized Long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<V> build();
        }
    }
}

