/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.sparkreceiver;

import java.nio.ByteBuffer;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.spark.SparkConf;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Function0;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;

public class WrappedSupervisor
extends ReceiverSupervisor {
    private final @UnknownKeyFor @NonNull @Initialized SparkConf sparkConf;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @Nullable @Initialized Void> storeFn;

    public WrappedSupervisor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Receiver<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> receiver, @UnknownKeyFor @NonNull @Initialized SparkConf conf, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @Nullable @Initialized Void> storeFn) {
        super(receiver, conf);
        this.sparkConf = conf;
        this.storeFn = storeFn;
    }

    public void pushSingle(@UnknownKeyFor @NonNull @Initialized Object o) {
        this.storeFn.apply((Object)new Object[]{o});
    }

    public void pushBytes(@UnknownKeyFor @NonNull @Initialized ByteBuffer byteBuffer, @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized Object> option, @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized StreamBlockId> option1) {
        this.storeFn.apply((Object)new Object[]{byteBuffer, option, option1});
    }

    public void pushIterator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> iterator, @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized Object> option, @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized StreamBlockId> option1) {
        this.storeFn.apply((Object)new Object[]{iterator, option, option1});
    }

    public void pushArrayBuffer(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ArrayBuffer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> arrayBuffer, @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized Object> option, @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized StreamBlockId> option1) {
        this.storeFn.apply((Object)new Object[]{arrayBuffer, option, option1});
    }

    public @UnknownKeyFor @NonNull @Initialized BlockGenerator createBlockGenerator(@UnknownKeyFor @NonNull @Initialized BlockGeneratorListener blockGeneratorListener) {
        return new BlockGenerator(blockGeneratorListener, this.streamId(), this.sparkConf, BlockGenerator.$lessinit$greater$default$4());
    }

    public void reportError(@UnknownKeyFor @NonNull @Initialized String s, @UnknownKeyFor @NonNull @Initialized Throwable throwable) {
    }

    public @UnknownKeyFor @NonNull @Initialized boolean onReceiverStart() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized long getCurrentRateLimit() {
        return Integer.MAX_VALUE;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isReceiverStopped() {
        return super.isReceiverStopped();
    }

    public void logInfo(@UnknownKeyFor @NonNull @Initialized Function0<@UnknownKeyFor @NonNull @Initialized String> msg) {
    }
}

