/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.sparkreceiver;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.commons.lang3.ClassUtils;
import org.apache.spark.streaming.receiver.Receiver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReceiverBuilder<@UnknownKeyFor X, @UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Receiver<X>>
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized Class<T> sparkReceiverClass;
    private @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] constructorArgs;

    public ReceiverBuilder(@UnknownKeyFor @NonNull @Initialized Class<T> sparkReceiverClass) {
        this.sparkReceiverClass = sparkReceiverClass;
        this.constructorArgs = new Object[0];
    }

    public @UnknownKeyFor @NonNull @Initialized ReceiverBuilder<X, T> withConstructorArgs(Object ... args) {
        this.constructorArgs = args;
        return this;
    }

    public T build() throws @UnknownKeyFor @NonNull @Initialized InvocationTargetException, @UnknownKeyFor @NonNull @Initialized InstantiationException, @UnknownKeyFor @NonNull @Initialized IllegalAccessException {
        Constructor<?> currentConstructor = null;
        for (Constructor<?> constructor : this.sparkReceiverClass.getDeclaredConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length != this.constructorArgs.length) continue;
            boolean matches = true;
            for (int i = 0; i < this.constructorArgs.length; ++i) {
                Object arg = this.constructorArgs[i];
                org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkArgument((arg != null ? 1 : 0) != 0, (Object)"All args must be not null!");
                Class currArgClass = paramTypes[i];
                if (currArgClass.isPrimitive()) {
                    currArgClass = ClassUtils.primitiveToWrapper(currArgClass);
                }
                if (currArgClass.equals(arg.getClass())) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            currentConstructor = constructor;
        }
        Preconditions.checkStateNotNull(currentConstructor, (Object)"Can not find appropriate constructor!");
        currentConstructor.setAccessible(true);
        return (T)((Receiver)this.sparkReceiverClass.cast(currentConstructor.newInstance(this.constructorArgs)));
    }

    public @UnknownKeyFor @NonNull @Initialized Class<T> getSparkReceiverClass() {
        return this.sparkReceiverClass;
    }
}

