/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.io.solr.AuthorizedSolrClient;
import org.apache.beam.sdk.io.solr.SolrIO;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

public class SolrIOTestUtils {
    public static final long MIN_DOC_SIZE = 30L;
    public static final long MAX_DOC_SIZE = 150L;

    static void createCollection(String collection, int numShards, int replicationFactor, AuthorizedSolrClient client) throws Exception {
        CollectionAdminRequest.Create create = CollectionAdminRequest.Create.createCollection((String)collection, (int)numShards, (int)replicationFactor).setMaxShardsPerNode(Integer.valueOf(2));
        client.process((CollectionAdminRequest)create);
    }

    static void insertTestDocuments(String collection, long numDocs, AuthorizedSolrClient client) throws IOException {
        List<SolrInputDocument> data = SolrIOTestUtils.createDocuments(numDocs);
        try {
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
            updateRequest.add(data);
            client.process(collection, (SolrRequest)updateRequest);
        }
        catch (SolrServerException e) {
            throw new IOException("Failed to insert test documents to collection", e);
        }
    }

    static void clearCollection(String collection, AuthorizedSolrClient client) throws IOException {
        try {
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
            updateRequest.deleteByQuery("*:*");
            client.process(collection, (SolrRequest)updateRequest);
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    static long commitAndGetCurrentNumDocs(String collection, AuthorizedSolrClient client) throws IOException {
        SolrQuery solrQuery = new SolrQuery("*:*");
        solrQuery.setRows(Integer.valueOf(0));
        try {
            UpdateRequest update = new UpdateRequest();
            update.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
            client.process(collection, (SolrRequest)update);
            return client.query(collection, (SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    static List<SolrInputDocument> createDocuments(long numDocs) {
        String[] scientists = new String[]{"Lovelace", "Franklin", "Meitner", "Hopper", "Curie", "Faraday", "Newton", "Bohr", "Galilei", "Maxwell"};
        ArrayList<SolrInputDocument> data = new ArrayList<SolrInputDocument>();
        int i = 0;
        while ((long)i < numDocs) {
            int index = i % scientists.length;
            SolrInputDocument doc = new SolrInputDocument(new String[0]);
            doc.setField("id", (Object)String.valueOf(i));
            doc.setField("scientist", (Object)scientists[index]);
            data.add(doc);
            ++i;
        }
        return data;
    }

    static boolean namedThreadIsAlive(String name) {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread t : threadSet) {
            if (!t.getName().equals(name) || !t.isAlive()) continue;
            return true;
        }
        return false;
    }

    static class LenientRetryPredicate
    implements SolrIO.RetryConfiguration.RetryPredicate {
        LenientRetryPredicate() {
        }

        public boolean test(Throwable throwable) {
            return throwable instanceof SolrException;
        }
    }
}

