/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.solr;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.io.solr.JavaBinCodecCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.solr.common.SolrDocument;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JavaBinCodecCoderTest {
    private static final Coder<SolrDocument> TEST_CODER = JavaBinCodecCoder.of(SolrDocument.class);
    private static final List<SolrDocument> TEST_VALUES = new ArrayList<SolrDocument>();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDecodeEncodeEqual() throws Exception {
        for (SolrDocument value : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeContentsInSameOrder(TEST_CODER, (Iterable)value);
            CoderProperties.structuralValueDecodeEncodeEqual(TEST_CODER, (Object)value);
        }
    }

    @Test
    public void encodeNullThrowsCoderException() throws Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null SolrDocument");
        CoderUtils.encodeToBase64(TEST_CODER, null);
    }

    @Test
    public void testEncodedTypeDescriptor() {
        MatcherAssert.assertThat((Object)TEST_CODER.getEncodedTypeDescriptor(), (Matcher)Matchers.equalTo((Object)TypeDescriptor.of(SolrDocument.class)));
    }

    static {
        SolrDocument doc = new SolrDocument();
        doc.put("id", (Object)"1");
        doc.put("content", (Object)"wheel on the bus");
        doc.put("_version_", (Object)1573597324260671488L);
        TEST_VALUES.add(doc);
        doc = new SolrDocument();
        doc.put("id", (Object)"2");
        doc.put("content", (Object)"goes round and round");
        doc.put("_version_", (Object)1573597324260671489L);
        TEST_VALUES.add(doc);
    }
}

