/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.solr;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.solr.AuthorizedSolrClient;
import org.apache.beam.sdk.io.solr.SolrIO;
import org.apache.beam.sdk.io.solr.SolrIOTestUtils;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.security.Sha256AuthenticationProvider;
import org.joda.time.Duration;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadLeakScope(value=ThreadLeakScope.Scope.NONE)
@SolrTestCaseJ4.SuppressSSL
@RunWith(value=RandomizedRunner.class)
public class SolrIOTest
extends SolrCloudTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(SolrIOTest.class);
    private static final String SOLR_COLLECTION = "beam";
    private static final int NUM_SHARDS = 3;
    private static final long NUM_DOCS = 400L;
    private static final int NUM_SCIENTISTS = 10;
    private static final int BATCH_SIZE = 200;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static AuthorizedSolrClient<CloudSolrClient> solrClient;
    private static SolrIO.ConnectionConfiguration connectionConfiguration;
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    @Rule
    public final transient ExpectedLogs expectedLogs = ExpectedLogs.none(SolrIO.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String password = "SolrRocks";
        byte[] salt = new byte[SolrIOTest.random().nextInt(30) + 1];
        SolrIOTest.random().nextBytes(salt);
        String base64Salt = BaseEncoding.base64().encode(salt);
        String sha56 = Sha256AuthenticationProvider.sha256((String)password, (String)base64Salt);
        String credential = sha56 + " " + base64Salt;
        String securityJson = "{'authentication':{  'blockUnknown': true,  'class':'solr.BasicAuthPlugin',  'credentials':{'solr':'" + credential + "'}}}";
        SolrIOTest.configureCluster((int)3).addConfig("conf", SolrIOTest.getFile((String)"cloud-minimal/conf").toPath()).configure();
        ZkStateReader zkStateReader = cluster.getSolrClient().getZkStateReader();
        zkStateReader.getZkClient().setData("/security.json", securityJson.getBytes(Charset.defaultCharset()), true);
        String zkAddress = cluster.getZkServer().getZkAddress();
        connectionConfiguration = SolrIO.ConnectionConfiguration.create((String)zkAddress).withBasicCredentials("solr", password);
        solrClient = connectionConfiguration.createClient();
        SolrIOTestUtils.createCollection(SOLR_COLLECTION, 3, 1, solrClient);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        solrClient.close();
    }

    @Before
    public void before() throws Exception {
        SolrIOTestUtils.clearCollection(SOLR_COLLECTION, solrClient);
    }

    @Test
    public void testBadCredentials() throws IOException {
        this.thrown.expect(SolrException.class);
        String zkAddress = cluster.getZkServer().getZkAddress();
        SolrIO.ConnectionConfiguration connectionConfiguration = SolrIO.ConnectionConfiguration.create((String)zkAddress).withBasicCredentials("solr", "wrongpassword");
        try (AuthorizedSolrClient solrClient = connectionConfiguration.createClient();){
            SolrIOTestUtils.insertTestDocuments(SOLR_COLLECTION, 400L, solrClient);
        }
    }

    @Test
    public void testRead() throws Exception {
        SolrIOTestUtils.insertTestDocuments(SOLR_COLLECTION, 400L, solrClient);
        PCollection output = (PCollection)this.pipeline.apply((PTransform)SolrIO.read().withConnectionConfiguration(connectionConfiguration).from(SOLR_COLLECTION).withBatchSize(101));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply("Count", Count.globally()))).isEqualTo((Object)400L);
        this.pipeline.run();
    }

    @Test
    public void testReadWithQuery() throws Exception {
        SolrIOTestUtils.insertTestDocuments(SOLR_COLLECTION, 400L, solrClient);
        PCollection output = (PCollection)this.pipeline.apply((PTransform)SolrIO.read().withConnectionConfiguration(connectionConfiguration).from(SOLR_COLLECTION).withQuery("scientist:Franklin"));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply("Count", Count.globally()))).isEqualTo((Object)40L);
        this.pipeline.run();
    }

    @Test
    public void testWrite() throws Exception {
        List<SolrInputDocument> data = SolrIOTestUtils.createDocuments(400L);
        SolrIO.Write write = SolrIO.write().withConnectionConfiguration(connectionConfiguration).to(SOLR_COLLECTION);
        ((PCollection)this.pipeline.apply((PTransform)Create.of(data))).apply((PTransform)write);
        this.pipeline.run();
        long currentNumDocs = SolrIOTestUtils.commitAndGetCurrentNumDocs(SOLR_COLLECTION, solrClient);
        SolrIOTest.assertEquals((long)400L, (long)currentNumDocs);
        QueryResponse response = solrClient.query(SOLR_COLLECTION, (SolrParams)new SolrQuery("scientist:Lovelace"));
        SolrIOTest.assertEquals((long)40L, (long)response.getResults().getNumFound());
    }

    @Test
    public void testWriteWithMaxBatchSize() throws Exception {
        SolrIO.Write write = SolrIO.write().withConnectionConfiguration(connectionConfiguration).to(SOLR_COLLECTION).withMaxBatchSize(200);
        try (DoFnTester fnTester = DoFnTester.of((DoFn)new SolrIO.Write.WriteFn(write));){
            List<SolrInputDocument> input = SolrIOTestUtils.createDocuments(400L);
            long numDocsProcessed = 0L;
            long numDocsInserted = 0L;
            for (SolrInputDocument document : input) {
                fnTester.processElement((Object)document);
                if (++numDocsProcessed % 100L != 0L) continue;
                long currentNumDocs = SolrIOTestUtils.commitAndGetCurrentNumDocs(SOLR_COLLECTION, solrClient);
                if (numDocsProcessed % 200L == 0L) {
                    SolrIOTest.assertEquals((String)"we are at the end of a bundle, we should have inserted all processed documents", (long)numDocsProcessed, (long)currentNumDocs);
                    numDocsInserted = currentNumDocs;
                    continue;
                }
                SolrIOTest.assertEquals((String)"we are not at the end of a bundle, we should have inserted no more documents", (long)numDocsInserted, (long)currentNumDocs);
            }
        }
    }

    @Test
    public void testWriteRetry() throws Throwable {
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("Error writing to Solr");
        ImmutableSet entryState = ImmutableSet.copyOf(ObjectReleaseTracker.OBJECTS.keySet());
        SolrIO.Write write = SolrIO.write().withConnectionConfiguration(connectionConfiguration).withRetryConfiguration(SolrIO.RetryConfiguration.create((int)3, (Duration)Duration.standardMinutes((long)3L)).withRetryPredicate((SolrIO.RetryConfiguration.RetryPredicate)new SolrIOTestUtils.LenientRetryPredicate())).to("wrong-collection");
        List<SolrInputDocument> data = SolrIOTestUtils.createDocuments(400L);
        ((PCollection)this.pipeline.apply((PTransform)Create.of(data))).apply((PTransform)write);
        try {
            this.pipeline.run();
        }
        catch (Pipeline.PipelineExecutionException e) {
            int waitAttempts = 30;
            while (SolrIOTestUtils.namedThreadIsAlive("direct-runner-worker") && waitAttempts-- >= 0) {
                LOG.info("Pausing to allow direct-runner-worker threads to finish");
                Thread.sleep(1000L);
            }
            for (Object o : ObjectReleaseTracker.OBJECTS.keySet()) {
                if (!(o instanceof SolrZkClient) || entryState.contains(o)) continue;
                LOG.info("Removing unreleased SolrZkClient");
                ObjectReleaseTracker.release(o);
            }
            this.expectedLogs.verifyWarn(String.format("Error writing to Solr. Retry attempt[%d]", 1));
            this.expectedLogs.verifyWarn(String.format("Error writing to Solr. Retry attempt[%d]", 2));
            throw e.getCause();
        }
        SolrIOTest.fail((String)"Pipeline should not have run to completion");
    }

    @Test
    public void testDefaultRetryPredicate() {
        SolrIOTest.assertTrue((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new IOException("test")));
        SolrIOTest.assertTrue((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrServerException("test")));
        SolrIOTest.assertTrue((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.CONFLICT, "test")));
        SolrIOTest.assertTrue((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.SERVER_ERROR, "test")));
        SolrIOTest.assertTrue((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "test")));
        SolrIOTest.assertTrue((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.INVALID_STATE, "test")));
        SolrIOTest.assertTrue((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.UNKNOWN, "test")));
        SolrIOTest.assertTrue((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new HttpSolrClient.RemoteSolrException("localhost", SolrException.ErrorCode.SERVICE_UNAVAILABLE.code, "test", (Throwable)new Exception())));
        SolrIOTest.assertFalse((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.BAD_REQUEST, "test")));
        SolrIOTest.assertFalse((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.FORBIDDEN, "test")));
        SolrIOTest.assertFalse((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.NOT_FOUND, "test")));
        SolrIOTest.assertFalse((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "test")));
        SolrIOTest.assertFalse((boolean)SolrIO.RetryConfiguration.DEFAULT_RETRY_PREDICATE.test((Object)new SolrException(SolrException.ErrorCode.UNSUPPORTED_MEDIA_TYPE, "test")));
    }

    @Test
    public void testBatchSize() {
        SolrIO.Write write1 = SolrIO.write().withConnectionConfiguration(connectionConfiguration).withMaxBatchSize(200);
        SolrIOTest.assertTrue((write1.getMaxBatchSize() == 200 ? 1 : 0) != 0);
        SolrIO.Write write2 = SolrIO.write().withConnectionConfiguration(connectionConfiguration);
        SolrIOTest.assertTrue((write2.getMaxBatchSize() == 1000 ? 1 : 0) != 0);
    }
}

