/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test.unit.write;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.sql.DataSource;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServices;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeBasicDataSource;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeDatabase;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeServicesImpl;
import org.apache.beam.sdk.io.snowflake.test.TestSnowflakePipelineOptions;
import org.apache.beam.sdk.io.snowflake.test.TestUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SnowflakeIOWriteTest {
    private static final String FAKE_TABLE = "FAKE_TABLE";
    private static final String BUCKET_NAME = "BUCKET/";
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    private static TestSnowflakePipelineOptions options;
    private static SnowflakeIO.DataSourceConfiguration dc;
    private static SnowflakeServices snowflakeServices;
    private static List<Long> testData;
    private static List<String> testDataInStrings;

    @BeforeClass
    public static void setupAll() {
        snowflakeServices = new FakeSnowflakeServicesImpl();
        testData = LongStream.range(0L, 100L).boxed().collect(Collectors.toList());
        testDataInStrings = new ArrayList<String>();
        testDataInStrings.add("First row");
        testDataInStrings.add("Second row with 'single' quotation");
        testDataInStrings.add("Second row with single one ' quotation");
        testDataInStrings.add("Second row with single twice '' quotation");
        testDataInStrings.add("Third row with \"double\" quotation");
        testDataInStrings.add("Third row with double one \" quotation");
        testDataInStrings.add("Third row with double twice \"\" quotation");
    }

    @Before
    public void setup() {
        FakeSnowflakeDatabase.createTable(FAKE_TABLE);
        PipelineOptionsFactory.register(TestSnowflakePipelineOptions.class);
        options = (TestSnowflakePipelineOptions)TestPipeline.testingPipelineOptions().as(TestSnowflakePipelineOptions.class);
        options.setStagingBucketName(BUCKET_NAME);
        options.setStorageIntegrationName("STORAGE_INTEGRATION");
        options.setServerName("NULL.snowflakecomputing.com");
        dc = SnowflakeIO.DataSourceConfiguration.create((DataSource)((Object)new FakeSnowflakeBasicDataSource())).withServerName(options.getServerName());
    }

    @After
    public void tearDown() {
        TestUtils.removeTempDir(BUCKET_NAME);
    }

    @Test
    public void writeWithIntegrationTest() throws SnowflakeSQLException {
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("Write SnowflakeIO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).withUserDataMapper(TestUtils.getLongCsvMapper()).to(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<Long> actualData = FakeSnowflakeDatabase.getElementsAsLong(FAKE_TABLE);
        Assert.assertTrue((boolean)TestUtils.areListsEqual(testData, actualData));
    }

    @Test
    public void writeWithMapperTest() throws SnowflakeSQLException {
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("text write IO", (PTransform)SnowflakeIO.write().to(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withDataSourceConfiguration(dc).withUserDataMapper(TestUtils.getLongCsvMapper()).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<Long> actualData = FakeSnowflakeDatabase.getElementsAsLong(FAKE_TABLE);
        Assert.assertTrue((boolean)TestUtils.areListsEqual(testData, actualData));
    }

    @Test
    public void writeWithKVInputTest() throws SnowflakeSQLException {
        ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply((PTransform)ParDo.of((DoFn)new TestUtils.ParseToKv()))).apply("Write SnowflakeIO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).withUserDataMapper(TestUtils.getLongCsvMapperKV()).to(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<String> actualData = FakeSnowflakeDatabase.getElements(FAKE_TABLE);
        List testDataInStrings = testData.stream().map(Object::toString).collect(Collectors.toList());
        Assert.assertTrue((boolean)TestUtils.areListsEqual(testDataInStrings, actualData));
    }

    @Test
    public void writeWithTransformationTest() throws SQLException {
        String query = "select t.$1 from %s t";
        ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply((PTransform)ParDo.of((DoFn)new TestUtils.ParseToKv()))).apply("Write SnowflakeIO", (PTransform)SnowflakeIO.write().to(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withUserDataMapper(TestUtils.getLongCsvMapperKV()).withDataSourceConfiguration(dc).withQueryTransformation(query).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<Long> actualData = FakeSnowflakeDatabase.getElementsAsLong(FAKE_TABLE);
        Assert.assertTrue((boolean)TestUtils.areListsEqual(testData, actualData));
    }

    @Test
    public void writeToExternalWithDoubleQuotation() throws SnowflakeSQLException {
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testDataInStrings))).apply("Write SnowflakeIO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).withUserDataMapper(TestUtils.getStringCsvMapper()).to(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withSnowflakeServices(snowflakeServices).withQuotationMark("\""));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<String> actualData = FakeSnowflakeDatabase.getElements(FAKE_TABLE);
        List escapedTestData = testDataInStrings.stream().map(e -> e.replace("'", "''")).map(e -> String.format("\"%s\"", e)).collect(Collectors.toList());
        Assert.assertTrue((boolean)TestUtils.areListsEqual(escapedTestData, actualData));
    }

    @Test
    public void writeToExternalWithBlankQuotation() throws SnowflakeSQLException {
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testDataInStrings))).apply("Write SnowflakeIO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).withUserDataMapper(TestUtils.getStringCsvMapper()).to(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withSnowflakeServices(snowflakeServices).withQuotationMark(""));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<String> actualData = FakeSnowflakeDatabase.getElements(FAKE_TABLE);
        List escapedTestData = testDataInStrings.stream().map(e -> e.replace("'", "''")).collect(Collectors.toList());
        Assert.assertTrue((boolean)TestUtils.areListsEqual(escapedTestData, actualData));
    }
}

