/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test.unit.write;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.sql.DataSource;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServices;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeBasicDataSource;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeDatabase;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeServicesImpl;
import org.apache.beam.sdk.io.snowflake.test.TestSnowflakePipelineOptions;
import org.apache.beam.sdk.io.snowflake.test.TestUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QueryDispositionLocationTest {
    private static final String FAKE_TABLE = "FAKE_TABLE";
    private static final String BUCKET_NAME = "BUCKET/";
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    private static TestSnowflakePipelineOptions options;
    private static SnowflakeIO.DataSourceConfiguration dc;
    private static SnowflakeServices snowflakeServices;
    private static List<Long> testData;

    @BeforeClass
    public static void setupAll() {
        PipelineOptionsFactory.register(TestSnowflakePipelineOptions.class);
        options = (TestSnowflakePipelineOptions)TestPipeline.testingPipelineOptions().as(TestSnowflakePipelineOptions.class);
        snowflakeServices = new FakeSnowflakeServicesImpl();
        testData = LongStream.range(0L, 100L).boxed().collect(Collectors.toList());
    }

    @Before
    public void setup() {
        options.setStagingBucketName(BUCKET_NAME);
        options.setStorageIntegrationName("STORAGE_INTEGRATION");
        options.setServerName("NULL.snowflakecomputing.com");
        dc = SnowflakeIO.DataSourceConfiguration.create((DataSource)((Object)new FakeSnowflakeBasicDataSource())).withServerName(options.getServerName());
    }

    @After
    public void tearDown() {
        TestUtils.removeTempDir(BUCKET_NAME);
    }

    @Test
    public void writeWithWriteTruncateDispositionSuccess() throws SQLException {
        FakeSnowflakeDatabase.createTable(FAKE_TABLE);
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("Truncate before write", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).to(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withUserDataMapper(TestUtils.getLongCsvMapper()).withFileNameTemplate("output").withWriteDisposition(WriteDisposition.TRUNCATE).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<Long> actualData = FakeSnowflakeDatabase.getElementsAsLong(FAKE_TABLE);
        Assert.assertTrue((boolean)TestUtils.areListsEqual(testData, actualData));
    }

    @Test
    public void writeWithWriteEmptyDispositionWithNotEmptyTableFails() {
        FakeSnowflakeDatabase.createTableWithElements(FAKE_TABLE, Arrays.asList("NOT_EMPTY"));
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("java.lang.RuntimeException: Table is not empty. Aborting COPY with disposition EMPTY");
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("Write SnowflakeIO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).to(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withUserDataMapper(TestUtils.getLongCsvMapper()).withFileNameTemplate("output").withWriteDisposition(WriteDisposition.EMPTY).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
    }

    @Test
    public void writeWithWriteEmptyDispositionWithEmptyTableSuccess() throws SQLException {
        FakeSnowflakeDatabase.createTable(FAKE_TABLE);
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("Write SnowflakeIO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).to(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withFileNameTemplate("output").withUserDataMapper(TestUtils.getLongCsvMapper()).withWriteDisposition(WriteDisposition.EMPTY).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<Long> actualData = FakeSnowflakeDatabase.getElementsAsLong(FAKE_TABLE);
        Assert.assertTrue((boolean)TestUtils.areListsEqual(testData, actualData));
    }
}

