/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test.unit.write;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.sql.DataSource;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeColumn;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeDataType;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeTableSchema;
import org.apache.beam.sdk.io.snowflake.data.text.SnowflakeVarchar;
import org.apache.beam.sdk.io.snowflake.enums.CreateDisposition;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServices;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeBasicDataSource;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeDatabase;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeServicesImpl;
import org.apache.beam.sdk.io.snowflake.test.TestSnowflakePipelineOptions;
import org.apache.beam.sdk.io.snowflake.test.TestUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CreateDispositionTest {
    private static final String FAKE_TABLE = "FAKE_TABLE";
    private static final String BUCKET_NAME = "bucket/";
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    private static TestSnowflakePipelineOptions options;
    private static SnowflakeIO.DataSourceConfiguration dc;
    private static String stagingBucketName;
    private static String storageIntegrationName;
    private static SnowflakeServices snowflakeServices;
    private static List<Long> testData;

    @BeforeClass
    public static void setupAll() {
        PipelineOptionsFactory.register(TestSnowflakePipelineOptions.class);
        options = (TestSnowflakePipelineOptions)TestPipeline.testingPipelineOptions().as(TestSnowflakePipelineOptions.class);
        options.setStagingBucketName(BUCKET_NAME);
        options.setServerName("NULL.snowflakecomputing.com");
        stagingBucketName = options.getStagingBucketName();
        storageIntegrationName = options.getStorageIntegrationName();
        snowflakeServices = new FakeSnowflakeServicesImpl();
        testData = LongStream.range(0L, 100L).boxed().collect(Collectors.toList());
        dc = SnowflakeIO.DataSourceConfiguration.create((DataSource)((Object)new FakeSnowflakeBasicDataSource())).withServerName(options.getServerName());
    }

    @Before
    public void setup() {
    }

    @After
    public void tearDown() {
        TestUtils.removeTempDir(BUCKET_NAME);
        FakeSnowflakeDatabase.clean();
    }

    @Test
    public void writeWithWriteCreateDispositionWithAlreadyCreatedTableSuccess() throws SQLException {
        FakeSnowflakeDatabase.createTable(FAKE_TABLE);
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("Copy IO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).to(FAKE_TABLE).withStagingBucketName(stagingBucketName).withStorageIntegrationName(storageIntegrationName).withUserDataMapper(TestUtils.getLongCsvMapper()).withFileNameTemplate("output").withCreateDisposition(CreateDisposition.CREATE_IF_NEEDED).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<Long> actualData = FakeSnowflakeDatabase.getElementsAsLong(FAKE_TABLE);
        Assert.assertTrue((boolean)TestUtils.areListsEqual(testData, actualData));
    }

    @Test
    public void writeWithWriteCreateDispositionWithCreatedTableWithoutSchemaFails() {
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("The CREATE_IF_NEEDED disposition requires schema if table doesn't exists");
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("Copy IO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).to("NO_EXIST_TABLE").withStagingBucketName(stagingBucketName).withStorageIntegrationName(storageIntegrationName).withFileNameTemplate("output").withUserDataMapper(TestUtils.getCsvMapper()).withCreateDisposition(CreateDisposition.CREATE_IF_NEEDED).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
    }

    @Test
    public void writeWithWriteCreateDispositionWithCreatedTableWithSchemaSuccess() throws SQLException {
        SnowflakeTableSchema tableSchema = new SnowflakeTableSchema(new SnowflakeColumn[]{SnowflakeColumn.of((String)"id", (SnowflakeDataType)new SnowflakeVarchar())});
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("Copy IO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).to("NO_EXIST_TABLE").withTableSchema(tableSchema).withStagingBucketName(stagingBucketName).withStorageIntegrationName(storageIntegrationName).withFileNameTemplate("output").withUserDataMapper(TestUtils.getLongCsvMapper()).withCreateDisposition(CreateDisposition.CREATE_IF_NEEDED).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<Long> actualData = FakeSnowflakeDatabase.getElementsAsLong("NO_EXIST_TABLE");
        Assert.assertTrue((boolean)TestUtils.areListsEqual(testData, actualData));
    }

    @Test
    public void writeWithWriteCreateDispositionWithCreateNeverSuccess() throws SQLException {
        FakeSnowflakeDatabase.createTable(FAKE_TABLE);
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("Copy IO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).to(FAKE_TABLE).withStagingBucketName(stagingBucketName).withStorageIntegrationName(storageIntegrationName).withFileNameTemplate("output").withUserDataMapper(TestUtils.getLongCsvMapper()).withCreateDisposition(CreateDisposition.CREATE_NEVER).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
        List<Long> actualData = FakeSnowflakeDatabase.getElementsAsLong(FAKE_TABLE);
        Assert.assertTrue((boolean)TestUtils.areListsEqual(testData, actualData));
    }

    @Test
    public void writeWithWriteCreateDispositionWithCreateNeededFails() {
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("SQL compilation error: Table does not exist");
        ((PCollection)this.pipeline.apply((PTransform)Create.of(testData))).apply("Copy IO", (PTransform)SnowflakeIO.write().withDataSourceConfiguration(dc).to("NO_EXIST_TABLE").withStagingBucketName(stagingBucketName).withStorageIntegrationName(storageIntegrationName).withFileNameTemplate("output").withUserDataMapper(TestUtils.getLongCsvMapper()).withCreateDisposition(CreateDisposition.CREATE_NEVER).withSnowflakeServices(snowflakeServices));
        this.pipeline.run((PipelineOptions)options).waitUntilFinish();
    }
}

