/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test.unit.read;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.AvroGeneratedUser;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServices;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeBasicDataSource;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeDatabase;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeServicesImpl;
import org.apache.beam.sdk.io.snowflake.test.TestSnowflakePipelineOptions;
import org.apache.beam.sdk.io.snowflake.test.TestUtils;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SnowflakeIOReadTest
implements Serializable {
    public static final String FAKE_TABLE = "FAKE_TABLE";
    public static final String FAKE_QUERY = "SELECT * FROM FAKE_TABLE";
    public static final String BUCKET_NAME = "BUCKET/";
    private static final TestSnowflakePipelineOptions options = (TestSnowflakePipelineOptions)TestPipeline.testingPipelineOptions().as(TestSnowflakePipelineOptions.class);
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private static SnowflakeIO.DataSourceConfiguration dataSourceConfiguration;
    private static SnowflakeServices snowflakeServices;
    private static List<GenericRecord> avroTestData;

    @BeforeClass
    public static void setup() {
        List<String> testData = Arrays.asList("Paul,51,red", "Jackson,41,green");
        avroTestData = ImmutableList.of((Object)new AvroGeneratedUser("Paul", Integer.valueOf(51), "red"), (Object)new AvroGeneratedUser("Jackson", Integer.valueOf(41), "green"));
        FakeSnowflakeDatabase.createTableWithElements(FAKE_TABLE, testData);
        options.setServerName("NULL.snowflakecomputing.com");
        options.setStorageIntegrationName("STORAGE_INTEGRATION");
        options.setStagingBucketName(BUCKET_NAME);
        dataSourceConfiguration = SnowflakeIO.DataSourceConfiguration.create((DataSource)((Object)new FakeSnowflakeBasicDataSource())).withServerName(options.getServerName());
        snowflakeServices = new FakeSnowflakeServicesImpl();
    }

    @AfterClass
    public static void tearDown() {
        TestUtils.removeTempDir(BUCKET_NAME);
    }

    @Test
    public void testConfigIsMissingStagingBucketName() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("withStagingBucketName() is required");
        this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).fromTable(FAKE_TABLE).withStorageIntegrationName(options.getStorageIntegrationName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        this.pipeline.run();
    }

    @Test
    public void testConfigIsMissingStorageIntegration() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("withStorageIntegrationName() is required");
        this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).fromTable(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        this.pipeline.run();
    }

    @Test
    public void testConfigIsMissingCsvMapper() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("withCsvMapper() is required");
        this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).fromTable(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        this.pipeline.run();
    }

    @Test
    public void testConfigIsMissingCoder() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("withCoder() is required");
        this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).fromTable(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()));
        this.pipeline.run();
    }

    @Test
    public void testConfigIsMissingFromTableOrFromQuery() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("fromTable() or fromQuery() is required");
        this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        this.pipeline.run();
    }

    @Test
    public void testConfigIsMissingDataSourceConfiguration() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("withDataSourceConfiguration() or withDataSourceProviderFn() is required");
        this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).fromTable(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        this.pipeline.run();
    }

    @Test
    public void testConfigContainsFromQueryAndFromTable() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("fromTable() and fromQuery() are not allowed together");
        this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).fromQuery("").fromTable(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        this.pipeline.run();
    }

    @Test
    public void testTableDoesntExist() {
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectMessage("SQL compilation error: Table does not exist");
        this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).fromTable("NON_EXIST").withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        this.pipeline.run();
    }

    @Test
    public void testInvalidQuery() {
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectMessage("SQL compilation error: Invalid query");
        this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).fromQuery("BAD_QUERY").withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        this.pipeline.run();
    }

    @Test
    public void testReadFromTable() {
        PCollection items = (PCollection)this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).fromTable(FAKE_TABLE).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        PAssert.that((PCollection)items).containsInAnyOrder(avroTestData);
        this.pipeline.run();
    }

    @Test
    public void testReadFromQuery() {
        PCollection items = (PCollection)this.pipeline.apply((PTransform)SnowflakeIO.read((SnowflakeServices)snowflakeServices).withDataSourceConfiguration(dataSourceConfiguration).fromQuery(FAKE_QUERY).withStagingBucketName(options.getStagingBucketName()).withStorageIntegrationName(options.getStorageIntegrationName()).withCsvMapper(SnowflakeIOReadTest.getCsvMapper()).withCoder((Coder)AvroCoder.of((Schema)AvroGeneratedUser.getClassSchema())));
        PAssert.that((PCollection)items).containsInAnyOrder(avroTestData);
        this.pipeline.run();
    }

    static SnowflakeIO.CsvMapper<GenericRecord> getCsvMapper() {
        return (SnowflakeIO.CsvMapper & Serializable)parts -> new GenericRecordBuilder(AvroGeneratedUser.getClassSchema()).set("name", (Object)String.valueOf(parts[0])).set("favorite_number", (Object)Integer.valueOf(parts[1])).set("favorite_color", (Object)String.valueOf(parts[2])).build();
    }
}

