/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test.unit.data;

import java.util.Arrays;
import java.util.Collection;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeDataType;
import org.apache.beam.sdk.io.snowflake.data.datetime.SnowflakeDate;
import org.apache.beam.sdk.io.snowflake.data.datetime.SnowflakeDateTime;
import org.apache.beam.sdk.io.snowflake.data.datetime.SnowflakeTime;
import org.apache.beam.sdk.io.snowflake.data.datetime.SnowflakeTimestamp;
import org.apache.beam.sdk.io.snowflake.data.datetime.SnowflakeTimestampLTZ;
import org.apache.beam.sdk.io.snowflake.data.datetime.SnowflakeTimestampNTZ;
import org.apache.beam.sdk.io.snowflake.data.datetime.SnowflakeTimestampTZ;
import org.apache.beam.sdk.io.snowflake.data.logical.SnowflakeBoolean;
import org.apache.beam.sdk.io.snowflake.data.numeric.SnowflakeDecimal;
import org.apache.beam.sdk.io.snowflake.data.numeric.SnowflakeDouble;
import org.apache.beam.sdk.io.snowflake.data.numeric.SnowflakeFloat;
import org.apache.beam.sdk.io.snowflake.data.numeric.SnowflakeInteger;
import org.apache.beam.sdk.io.snowflake.data.numeric.SnowflakeNumber;
import org.apache.beam.sdk.io.snowflake.data.numeric.SnowflakeNumeric;
import org.apache.beam.sdk.io.snowflake.data.numeric.SnowflakeReal;
import org.apache.beam.sdk.io.snowflake.data.structured.SnowflakeArray;
import org.apache.beam.sdk.io.snowflake.data.structured.SnowflakeObject;
import org.apache.beam.sdk.io.snowflake.data.structured.SnowflakeVariant;
import org.apache.beam.sdk.io.snowflake.data.text.SnowflakeBinary;
import org.apache.beam.sdk.io.snowflake.data.text.SnowflakeChar;
import org.apache.beam.sdk.io.snowflake.data.text.SnowflakeString;
import org.apache.beam.sdk.io.snowflake.data.text.SnowflakeText;
import org.apache.beam.sdk.io.snowflake.data.text.SnowflakeVarBinary;
import org.apache.beam.sdk.io.snowflake.data.text.SnowflakeVarchar;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SnowflakeDataTypeValidTest {
    private SnowflakeDataType snowflakeDataType;
    private String expectedResult;

    public SnowflakeDataTypeValidTest(SnowflakeDataType snowflakeDataType, String expectedResult) {
        this.snowflakeDataType = snowflakeDataType;
        this.expectedResult = expectedResult;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> primeNumbers() {
        return Arrays.asList({SnowflakeBoolean.of(), "BOOLEAN"}, {SnowflakeDate.of(), "DATE"}, {SnowflakeDateTime.of(), "TIMESTAMP_NTZ"}, {SnowflakeTime.of(), "TIME"}, {SnowflakeDateTime.of(), "TIMESTAMP_NTZ"}, {SnowflakeTimestamp.of(), "TIMESTAMP_NTZ"}, {SnowflakeTimestampNTZ.of(), "TIMESTAMP_NTZ"}, {SnowflakeTimestampLTZ.of(), "TIMESTAMP_LTZ"}, {SnowflakeTimestampTZ.of(), "TIMESTAMP_TZ"}, {SnowflakeDecimal.of((int)20, (int)1), "NUMBER(20,1)"}, {SnowflakeDouble.of(), "FLOAT"}, {SnowflakeFloat.of(), "FLOAT"}, {SnowflakeInteger.of(), "NUMBER(38,0)"}, {SnowflakeNumber.of(), "NUMBER(38,0)"}, {SnowflakeNumeric.of((int)33, (int)2), "NUMBER(33,2)"}, {SnowflakeReal.of(), "FLOAT"}, {SnowflakeVariant.of(), "VARIANT"}, {SnowflakeArray.of(), "ARRAY"}, {SnowflakeObject.of(), "OBJECT"}, {SnowflakeVarchar.of(), "VARCHAR"}, {SnowflakeVarchar.of((long)100L), "VARCHAR(100)"}, {SnowflakeString.of(), "VARCHAR"}, {SnowflakeText.of(), "VARCHAR"}, {SnowflakeBinary.of(), "BINARY"}, {SnowflakeVarBinary.of(), "BINARY"}, {SnowflakeBinary.of((long)100L), "BINARY(100)"}, {SnowflakeChar.of(), "VARCHAR(1)"});
    }

    @Test
    public void testSnowflakeDataType() {
        Assert.assertEquals((Object)this.expectedResult, (Object)this.snowflakeDataType.sql());
    }
}

