/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test.unit;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.test.TestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSourceConfigurationTest {
    private SnowflakeIO.DataSourceConfiguration configuration;
    private static final String SERVER_NAME = "account.snowflakecomputing.com";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    @Before
    public void setUp() {
        this.configuration = SnowflakeIO.DataSourceConfiguration.create();
    }

    @Test
    public void testSettingUrlWithBadPrefix() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.configuration.withUrl(SERVER_NAME));
    }

    @Test
    public void testSettingUrlWithBadSuffix() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.configuration.withUrl("jdbc:snowflake://account"));
    }

    @Test
    public void testSettingStringUrl() {
        String url = "jdbc:snowflake://account.snowflakecomputing.com";
        this.configuration = this.configuration.withUrl(url);
        Assert.assertEquals((Object)url, (Object)this.configuration.getUrl());
    }

    @Test
    public void testSettingServerNameWithBadSuffix() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.configuration.withServerName("not.properly.ended"));
    }

    @Test
    public void testSettingStringServerName() {
        this.configuration = this.configuration.withServerName(SERVER_NAME);
        Assert.assertEquals((Object)SERVER_NAME, (Object)this.configuration.getServerName().get());
    }

    @Test
    public void testSettingStringDatabase() {
        String database = "dbname";
        this.configuration = this.configuration.withDatabase(database);
        Assert.assertEquals((Object)database, (Object)this.configuration.getDatabase().get());
    }

    @Test
    public void testSettingStringWarehouse() {
        String warehouse = "warehouse";
        this.configuration = this.configuration.withWarehouse(warehouse);
        Assert.assertEquals((Object)warehouse, (Object)this.configuration.getWarehouse().get());
    }

    @Test
    public void testSettingStringSchema() {
        String schema = "schema";
        this.configuration = this.configuration.withSchema(schema);
        Assert.assertEquals((Object)schema, (Object)this.configuration.getSchema().get());
    }

    @Test
    public void testSettingStringRole() {
        String role = "role";
        this.configuration = this.configuration.withRole(role);
        Assert.assertEquals((Object)role, (Object)this.configuration.getRole().get());
    }

    @Test
    public void testSettingStringAuthenticator() {
        String authenticator = "authenticator";
        this.configuration = this.configuration.withAuthenticator(authenticator);
        Assert.assertEquals((Object)authenticator, (Object)this.configuration.getAuthenticator());
    }

    @Test
    public void testSettingStringPortNumber() {
        Integer portNumber = 1234;
        this.configuration = this.configuration.withPortNumber(portNumber);
        Assert.assertEquals((Object)portNumber, (Object)this.configuration.getPortNumber());
    }

    @Test
    public void testSettingStringLoginTimeout() {
        Integer loginTimeout = 999;
        this.configuration = this.configuration.withLoginTimeout(loginTimeout);
        Assert.assertEquals((Object)loginTimeout, (Object)this.configuration.getLoginTimeout());
    }

    @Test
    public void testDataSourceCreatedFromUrl() {
        String url = "jdbc:snowflake://account.snowflakecomputing.com";
        String expectedUrl = "jdbc:snowflake://account.snowflakecomputing.com?application=beam";
        this.configuration = this.configuration.withOAuth("some-token").withUrl(url);
        DataSource dataSource = this.configuration.buildDatasource();
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        Assert.assertEquals((Object)expectedUrl, (Object)((SnowflakeBasicDataSource)dataSource).getUrl());
    }

    @Test
    public void testDataSourceCreatedFromServerName() {
        this.configuration = this.configuration.withOAuth("some-token").withServerName(SERVER_NAME);
        DataSource dataSource = this.configuration.buildDatasource();
        String expectedUrl = "jdbc:snowflake://account.snowflakecomputing.com?application=beam";
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        Assert.assertEquals((Object)expectedUrl, (Object)((SnowflakeBasicDataSource)dataSource).getUrl());
    }

    @Test
    public void testDataSourceCreatedFromServerNameAndPort() {
        int portNumber = 1234;
        this.configuration = this.configuration.withOAuth("some-token").withServerName(SERVER_NAME).withPortNumber(Integer.valueOf(portNumber));
        DataSource dataSource = this.configuration.buildDatasource();
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        String expectedUrl = "jdbc:snowflake://account.snowflakecomputing.com:1234?application=beam";
        Assert.assertEquals((Object)expectedUrl, (Object)((SnowflakeBasicDataSource)dataSource).getUrl());
    }

    @Test
    public void testSettingUsernamePasswordAuth() {
        this.configuration = this.configuration.withUsernamePasswordAuth(USERNAME, PASSWORD).withServerName(SERVER_NAME);
        DataSource dataSource = this.configuration.buildDatasource();
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        Assert.assertEquals((Object)USERNAME, (Object)this.configuration.getUsername().get());
        Assert.assertEquals((Object)PASSWORD, (Object)this.configuration.getPassword().get());
    }

    @Test
    public void testSettingUsernamePasswordAuthWithMissingUsername() {
        this.configuration = this.configuration.withServerName(SERVER_NAME).withUsernamePasswordAuth(null, PASSWORD);
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.buildDatasource());
        Assert.assertEquals((Object)"Missing credentials values. Please check your credentials", (Object)ex.getMessage());
    }

    @Test
    public void testSettingOAuth() {
        String token = "token";
        this.configuration = this.configuration.withOAuth(token).withServerName(SERVER_NAME);
        DataSource dataSource = this.configuration.buildDatasource();
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        Assert.assertEquals((Object)token, (Object)this.configuration.getOauthToken().get());
    }

    @Test
    public void testSettingKeyPairAuthWithProperPathToKey() {
        String privateKeyPath = TestUtils.getValidEncryptedPrivateKeyPath(this.getClass());
        String keyPassphrase = TestUtils.getPrivateKeyPassphrase();
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairPathAuth(USERNAME, privateKeyPath, keyPassphrase);
        DataSource dataSource = this.configuration.buildDatasource();
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        Assert.assertEquals((Object)USERNAME, (Object)this.configuration.getUsername().get());
        Assert.assertNotNull((Object)this.configuration.getRawPrivateKey());
        Assert.assertEquals((Object)keyPassphrase, (Object)this.configuration.getPrivateKeyPassphrase().get());
    }

    @Test
    public void testSettingKeyPairAuthWithProperPathToKeyAndInvalidKey() {
        String privateKeyPath = TestUtils.getInvalidPrivateKeyPath(this.getClass());
        String keyPassphrase = TestUtils.getPrivateKeyPassphrase();
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairPathAuth(USERNAME, privateKeyPath, keyPassphrase);
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.buildDatasource());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"Can't create private key: "));
    }

    @Test
    public void testSettingKeyPairAuthWithProperPathToUnencryptedKeyAndPassphrase() {
        String privateKeyPath = TestUtils.getValidUnencryptedPrivateKeyPath(this.getClass());
        String keyPassphrase = "test-passphrase";
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairPathAuth(USERNAME, privateKeyPath, keyPassphrase);
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.buildDatasource());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"The private key is unencrypted but private key key passphrase has been provided."));
    }

    @Test
    public void testSettingKeyPairAuthWithProperPathToEncryptedKeyAndNoPassphrase() {
        String privateKeyPath = TestUtils.getValidEncryptedPrivateKeyPath(this.getClass());
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairPathAuth(USERNAME, privateKeyPath);
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.buildDatasource());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"The private key is encrypted but no private key key passphrase has been provided."));
    }

    @Test
    public void testSettingKeyPairAuthWithProperPathToEncryptedKeyAndInvalidPassphrase() {
        String privateKeyPath = TestUtils.getValidEncryptedPrivateKeyPath(this.getClass());
        String keyPassphrase = "invalid-passphrase";
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairPathAuth(USERNAME, privateKeyPath, keyPassphrase);
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.buildDatasource());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"Can't create private key: "));
    }

    @Test
    public void testSettingKeyPairAuthWithProperPathToKeyAndMissingUsername() {
        String privateKeyPath = TestUtils.getValidEncryptedPrivateKeyPath(this.getClass());
        String keyPassphrase = TestUtils.getPrivateKeyPassphrase();
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairPathAuth(null, privateKeyPath, keyPassphrase);
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.buildDatasource());
        Assert.assertEquals((Object)"Missing credentials values. Please check your credentials", (Object)ex.getMessage());
    }

    @Test
    public void testSettingKeyPairAuthWithProperRawKey() throws IOException {
        String rawPrivateKey = TestUtils.getRawValidEncryptedPrivateKey(this.getClass());
        String keyPassphrase = TestUtils.getPrivateKeyPassphrase();
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairRawAuth(USERNAME, rawPrivateKey, keyPassphrase);
        DataSource dataSource = this.configuration.buildDatasource();
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        Assert.assertEquals((Object)USERNAME, (Object)this.configuration.getUsername().get());
        Assert.assertEquals((Object)rawPrivateKey, (Object)this.configuration.getRawPrivateKey().get());
        Assert.assertEquals((Object)keyPassphrase, (Object)this.configuration.getPrivateKeyPassphrase().get());
    }

    @Test
    public void testSettingKeyPairAuthWithProperRawEncryptedKeyWithoutHeaders() throws IOException {
        String rawPrivateKey = Arrays.stream(TestUtils.getRawValidEncryptedPrivateKey(this.getClass()).split("\n")).filter(d -> !d.contains("---")).collect(Collectors.joining("\n"));
        String keyPassphrase = TestUtils.getPrivateKeyPassphrase();
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairRawAuth(USERNAME, rawPrivateKey, keyPassphrase);
        DataSource dataSource = this.configuration.buildDatasource();
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        Assert.assertEquals((Object)USERNAME, (Object)this.configuration.getUsername().get());
        Assert.assertEquals((Object)rawPrivateKey, (Object)this.configuration.getRawPrivateKey().get());
        Assert.assertEquals((Object)keyPassphrase, (Object)this.configuration.getPrivateKeyPassphrase().get());
    }

    @Test
    public void testSettingKeyPairAuthWithProperRawUnencryptedKeyWithoutHeaders() throws IOException {
        String rawPrivateKey = Arrays.stream(TestUtils.getRawValidUnencryptedPrivateKey(this.getClass()).split("\n")).filter(d -> !d.contains("---")).collect(Collectors.joining("\n"));
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairRawAuth(USERNAME, rawPrivateKey);
        DataSource dataSource = this.configuration.buildDatasource();
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        Assert.assertEquals((Object)USERNAME, (Object)this.configuration.getUsername().get());
        Assert.assertEquals((Object)rawPrivateKey, (Object)this.configuration.getRawPrivateKey().get());
    }

    @Test
    public void testSettingKeyPairAuthWithProperRawUnencryptedKey() throws IOException {
        String rawPrivateKey = TestUtils.getRawValidUnencryptedPrivateKey(this.getClass());
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairRawAuth(USERNAME, rawPrivateKey);
        DataSource dataSource = this.configuration.buildDatasource();
        Assert.assertEquals(SnowflakeBasicDataSource.class, dataSource.getClass());
        Assert.assertEquals((Object)USERNAME, (Object)this.configuration.getUsername().get());
        Assert.assertEquals((Object)rawPrivateKey, (Object)this.configuration.getRawPrivateKey().get());
    }

    @Test
    public void testSettingKeyPairAuthWithProperRawKeyAndMissingUsername() throws IOException {
        String rawPrivateKey = TestUtils.getRawValidEncryptedPrivateKey(this.getClass());
        String keyPassphrase = TestUtils.getPrivateKeyPassphrase();
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairRawAuth(null, rawPrivateKey, keyPassphrase);
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.buildDatasource());
        Assert.assertEquals((Object)"Missing credentials values. Please check your credentials", (Object)ex.getMessage());
    }

    @Test
    public void testSettingKeyPairAuthWithWrongPathToKey() {
        String privateKeyPath = "wrong/path/to/key/key.p8";
        String keyPassphrase = TestUtils.getPrivateKeyPassphrase();
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.withServerName(SERVER_NAME).withKeyPairPathAuth(USERNAME, privateKeyPath, keyPassphrase));
        Assert.assertEquals((Object)"Can't read private key from provided path", (Object)ex.getMessage());
    }

    @Test
    public void testSettingKeyPairAuthWithWrongKey() {
        String rawPrivateKey = "invalid_key";
        String keyPassphrase = TestUtils.getPrivateKeyPassphrase();
        this.configuration = this.configuration.withServerName(SERVER_NAME).withKeyPairRawAuth(USERNAME, rawPrivateKey, keyPassphrase);
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.buildDatasource());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"Can't create private key: "));
    }

    @Test
    public void testSettingNonAuth() {
        this.configuration = this.configuration.withServerName(SERVER_NAME);
        Exception ex = (Exception)Assert.assertThrows(RuntimeException.class, () -> this.configuration.buildDatasource());
        Assert.assertEquals((Object)"Missing credentials values. Please check your credentials", (Object)ex.getMessage());
    }
}

