/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServices;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeStreamingServiceConfig;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeIngestManager;

public class FakeSnowflakeStreamingServiceImpl
implements SnowflakeServices.StreamingService {
    private FakeSnowflakeIngestManager snowflakeIngestManager;

    public void write(SnowflakeStreamingServiceConfig config) throws Exception {
        this.snowflakeIngestManager = new FakeSnowflakeIngestManager();
        this.ingest(config);
    }

    public String read(SnowflakeStreamingServiceConfig config) throws Exception {
        throw new UnsupportedOperationException("Streaming read is not supported in SnowflakeIO.");
    }

    public void ingest(SnowflakeStreamingServiceConfig config) {
        ArrayList<String> rows = new ArrayList<String>();
        List filesList = config.getFilesList();
        for (String file : filesList) {
            rows.addAll(this.readGZIPFile(file.replace("'", "")));
        }
        this.snowflakeIngestManager.ingestFiles(rows);
    }

    private List<String> readGZIPFile(String file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(file));
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gzip, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file", e);
        }
        return lines;
    }
}

