/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.SnowflakeSQLException;

public class FakeSnowflakeDatabase
implements Serializable {
    private static Map<String, List<String>> tables = new HashMap<String, List<String>>();

    private FakeSnowflakeDatabase() {
        tables = new HashMap<String, List<String>>();
    }

    public static void createTable(String table) {
        tables.put(table, Collections.emptyList());
    }

    public static List<String> getElements(String table) throws SnowflakeSQLException {
        if (!FakeSnowflakeDatabase.isTableExist(table)) {
            throw new SnowflakeSQLException(null, "SQL compilation error: Table does not exist", table, 0);
        }
        return tables.get(table);
    }

    public static List<String> runQuery(String query) throws SnowflakeSQLException {
        if (query.startsWith("SELECT * FROM ")) {
            String tableName = query.replace("SELECT * FROM ", "");
            return FakeSnowflakeDatabase.getElements(tableName);
        }
        throw new SnowflakeSQLException(null, "SQL compilation error: Invalid query", query, 0);
    }

    public static List<Long> getElementsAsLong(String table) throws SnowflakeSQLException {
        List<String> elements = FakeSnowflakeDatabase.getElements(table);
        return elements.stream().map(Long::parseLong).collect(Collectors.toList());
    }

    public static boolean isTableExist(String table) {
        return tables.containsKey(table);
    }

    public static boolean isTableEmpty(String table) {
        return tables.get(table).isEmpty();
    }

    public static void createTableWithElements(String table, List<String> rows) {
        tables.put(table, rows);
    }

    public static void clean() {
        tables = new HashMap<String, List<String>>();
    }

    public static void truncateTable(String table) {
        FakeSnowflakeDatabase.createTable(table);
    }
}

