/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeTableSchema;
import org.apache.beam.sdk.io.snowflake.enums.CreateDisposition;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeBatchServiceConfig;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServices;
import org.apache.beam.sdk.io.snowflake.test.FakeSnowflakeDatabase;
import org.apache.beam.sdk.io.snowflake.test.TestUtils;

public class FakeSnowflakeBatchServiceImpl
implements SnowflakeServices.BatchService {
    public void write(SnowflakeBatchServiceConfig config) throws Exception {
        this.copyToTable(config);
    }

    public String read(SnowflakeBatchServiceConfig config) throws Exception {
        return this.copyIntoStage(config);
    }

    public String copyIntoStage(SnowflakeBatchServiceConfig config) throws SQLException {
        String table = config.getTable();
        String query = config.getQuery();
        String stagingBucketDir = config.getStagingBucketDir();
        if (table != null) {
            this.writeToFile(stagingBucketDir, FakeSnowflakeDatabase.getElements(table));
        }
        if (query != null) {
            this.writeToFile(stagingBucketDir, FakeSnowflakeDatabase.runQuery(query));
        }
        return String.format("./%s/*", stagingBucketDir);
    }

    public void copyToTable(SnowflakeBatchServiceConfig config) throws SQLException {
        List filesList = config.getFilesList();
        String table = config.getTable();
        SnowflakeTableSchema tableSchema = config.getTableSchema();
        CreateDisposition createDisposition = config.getCreateDisposition();
        WriteDisposition writeDisposition = config.getWriteDisposition();
        ArrayList<String> rows = new ArrayList<String>();
        for (String file : filesList) {
            rows.addAll(TestUtils.readGZIPFile(file.replace("'", "")));
        }
        this.prepareTableAccordingCreateDisposition(table, tableSchema, createDisposition);
        this.prepareTableAccordingWriteDisposition(table, writeDisposition);
        FakeSnowflakeDatabase.createTableWithElements(table, rows);
    }

    private void prepareTableAccordingCreateDisposition(String table, SnowflakeTableSchema tableSchema, CreateDisposition createDisposition) throws SQLException {
        switch (createDisposition) {
            case CREATE_NEVER: {
                if (FakeSnowflakeDatabase.isTableExist(table)) break;
                throw new SnowflakeSQLException(null, "SQL compilation error: Table does not exist", table, 0);
            }
            case CREATE_IF_NEEDED: {
                if (FakeSnowflakeDatabase.isTableExist(table)) break;
                if (tableSchema == null) {
                    throw new RuntimeException("The CREATE_IF_NEEDED disposition requires schema if table doesn't exists");
                }
                FakeSnowflakeDatabase.createTable(table);
            }
        }
    }

    private void prepareTableAccordingWriteDisposition(String table, WriteDisposition writeDisposition) throws SQLException {
        switch (writeDisposition) {
            case TRUNCATE: {
                FakeSnowflakeDatabase.truncateTable(table);
                break;
            }
            case EMPTY: {
                if (FakeSnowflakeDatabase.isTableEmpty(table)) break;
                throw new RuntimeException("Table is not empty. Aborting COPY with disposition EMPTY");
            }
        }
    }

    private void writeToFile(String stagingBucketNameTmp, List<String> rows) {
        Path filePath = Paths.get(String.format("./%s/table.csv.gz", stagingBucketNameTmp), new String[0]);
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.createFile(filePath, new FileAttribute[0]);
            Files.write(filePath, rows, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create files", e);
        }
    }
}

