/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.test;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.common.HashingFn;
import org.apache.beam.sdk.io.common.IOITHelper;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeColumn;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeDataType;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeTableSchema;
import org.apache.beam.sdk.io.snowflake.data.numeric.SnowflakeInteger;
import org.apache.beam.sdk.io.snowflake.data.text.SnowflakeString;
import org.apache.beam.sdk.io.snowflake.enums.CreateDisposition;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.io.snowflake.test.TestUtils;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class BatchSnowflakeIOIT {
    private static final String tableName = "IOIT";
    private static SnowflakeIO.DataSourceConfiguration dataSourceConfiguration;
    private static int numberOfRecords;
    private static String stagingBucketName;
    private static String storageIntegrationName;
    @Rule
    public TestPipeline pipelineWrite = TestPipeline.create();
    @Rule
    public TestPipeline pipelineRead = TestPipeline.create();

    @BeforeClass
    public static void setup() throws SQLException {
        TestUtils.SnowflakeIOITPipelineOptions options = (TestUtils.SnowflakeIOITPipelineOptions)IOITHelper.readIOTestPipelineOptions(TestUtils.SnowflakeIOITPipelineOptions.class);
        numberOfRecords = options.getNumberOfRecords();
        stagingBucketName = options.getStagingBucketName();
        storageIntegrationName = options.getStorageIntegrationName();
        dataSourceConfiguration = SnowflakeIO.DataSourceConfiguration.create().withUsernamePasswordAuth(options.getUsername(), options.getPassword()).withDatabase(options.getDatabase()).withRole(options.getRole()).withWarehouse(options.getWarehouse()).withServerName(options.getServerName()).withSchema(options.getSchema());
    }

    @Test
    public void testWriteThenRead() {
        PipelineResult writeResult = this.runWrite();
        writeResult.waitUntilFinish();
        PipelineResult readResult = this.runRead();
        readResult.waitUntilFinish();
    }

    @AfterClass
    public static void teardown() throws Exception {
        String combinedPath = stagingBucketName + "/**";
        List paths = FileSystems.match((String)combinedPath).metadata().stream().map(MatchResult.Metadata::resourceId).collect(Collectors.toList());
        FileSystems.delete(paths, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
        TestUtils.runConnectionWithStatement(dataSourceConfiguration.buildDatasource(), String.format("DROP TABLE %s", tableName));
    }

    private PipelineResult runWrite() {
        ((PCollection)((PCollection)this.pipelineWrite.apply((PTransform)GenerateSequence.from((long)0L).to((long)numberOfRecords))).apply((PTransform)ParDo.of((DoFn)new TestRow.DeterministicallyConstructTestRowFn()))).apply((PTransform)SnowflakeIO.write().withDataSourceConfiguration(dataSourceConfiguration).withWriteDisposition(WriteDisposition.TRUNCATE).withUserDataMapper(TestUtils.getTestRowDataMapper()).to(tableName).withStagingBucketName(stagingBucketName).withStorageIntegrationName(storageIntegrationName).withCreateDisposition(CreateDisposition.CREATE_IF_NEEDED).withTableSchema(SnowflakeTableSchema.of((SnowflakeColumn[])new SnowflakeColumn[]{SnowflakeColumn.of((String)"id", (SnowflakeDataType)SnowflakeInteger.of()), SnowflakeColumn.of((String)"name", (SnowflakeDataType)SnowflakeString.of())})));
        return this.pipelineWrite.run();
    }

    private PipelineResult runRead() {
        PCollection namesAndIds = (PCollection)this.pipelineRead.apply((PTransform)SnowflakeIO.read().withDataSourceConfiguration(dataSourceConfiguration).fromTable(tableName).withStagingBucketName(stagingBucketName).withStorageIntegrationName(storageIntegrationName).withCsvMapper(TestUtils.getTestRowCsvMapper()).withCoder((Coder)SerializableCoder.of(TestRow.class)));
        PAssert.thatSingleton((PCollection)((PCollection)namesAndIds.apply("Count All", Count.globally()))).isEqualTo((Object)numberOfRecords);
        PCollection consolidatedHashcode = (PCollection)((PCollection)namesAndIds.apply((PTransform)ParDo.of((DoFn)new TestRow.SelectNameFn()))).apply("Hash row contents", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()).withoutDefaults());
        PAssert.that((PCollection)consolidatedHashcode).containsInAnyOrder((Object[])new String[]{TestRow.getExpectedHashForRowCount((int)numberOfRecords)});
        return this.pipelineRead.run();
    }
}

