/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.IngestResponseException;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeService;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeStreamingServiceConfig;

public class SnowflakeStreamingServiceImpl
implements SnowflakeService<SnowflakeStreamingServiceConfig> {
    private transient SimpleIngestManager ingestManager;

    @Override
    public void write(SnowflakeStreamingServiceConfig config) throws Exception {
        this.ingest(config);
    }

    @Override
    public String read(SnowflakeStreamingServiceConfig config) throws Exception {
        throw new UnsupportedOperationException("Not supported by SnowflakeIO.");
    }

    private void ingest(SnowflakeStreamingServiceConfig config) throws IngestResponseException, IOException, URISyntaxException {
        List<String> filesList = config.getFilesList();
        String stagingBucketDir = config.getStagingBucketDir();
        this.ingestManager = config.getIngestManager();
        Set files = filesList.stream().map(e -> e.replaceAll(String.valueOf(stagingBucketDir), "")).map(e -> e.replaceAll("'", "")).collect(Collectors.toSet());
        if (!files.isEmpty()) {
            this.ingestManager.ingestFiles(SimpleIngestManager.wrapFilepaths(files), null);
        }
    }
}

