/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.singlestore;

import com.singlestore.jdbc.Statement;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.io.singlestore.SingleStoreIO;
import org.apache.beam.sdk.io.singlestore.TestHelper;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class WriteTest {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    public final transient Pipeline pipelineForErrorChecks = Pipeline.create();
    private static SingleStoreIO.DataSourceConfiguration dataSourceConfiguration;
    private static final int EXPECTED_ROW_COUNT = 1000;
    private static final List<TestRow> writtenRows;

    void checkRows() {
        Assert.assertEquals(new HashSet(Lists.newArrayList((Iterable)TestRow.getExpectedValues((int)0, (int)1000))), new HashSet<TestRow>(writtenRows));
    }

    @After
    public void cleanup() {
        writtenRows.clear();
    }

    @Before
    public void init() {
        dataSourceConfiguration = (SingleStoreIO.DataSourceConfiguration)Mockito.mock(TestHelper.MockDataSourceConfiguration.class, (MockSettings)Mockito.withSettings().serializable());
        ((SingleStoreIO.DataSourceConfiguration)Mockito.doAnswer((Answer)new GetDataSource()).when((Object)dataSourceConfiguration)).getDataSource();
    }

    @Test
    public void testWrite() {
        int batchSize = 334;
        PCollection rows = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(1000L))).apply((PTransform)ParDo.of((DoFn)new TestRow.DeterministicallyConstructTestRowFn()))).apply((PTransform)SingleStoreIO.write().withDataSourceConfiguration(dataSourceConfiguration).withTable("t").withUserDataMapper((SingleStoreIO.UserDataMapper)new TestHelper.TestUserDataMapper()).withBatchSize(Integer.valueOf(batchSize)));
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Sum All", (PTransform)Sum.integersGlobally()))).isEqualTo((Object)1000);
        PAssert.that((PCollection)rows).satisfies((SerializableFunction)new BatchSizeChecker(batchSize));
        this.pipeline.run();
        this.checkRows();
    }

    @Test
    public void testWriteSmallBatchSize() {
        PCollection rows = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(1000L))).apply((PTransform)ParDo.of((DoFn)new TestRow.DeterministicallyConstructTestRowFn()))).apply((PTransform)SingleStoreIO.write().withDataSourceConfiguration(dataSourceConfiguration).withTable("t").withUserDataMapper((SingleStoreIO.UserDataMapper)new TestHelper.TestUserDataMapper()).withBatchSize(Integer.valueOf(1)));
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Sum All", (PTransform)Sum.integersGlobally()))).isEqualTo((Object)1000);
        PAssert.that((PCollection)rows).satisfies((SerializableFunction)new BatchSizeChecker(1));
        this.pipeline.run();
        this.checkRows();
    }

    @Test
    public void testWriteBigBatchSize() {
        PCollection rows = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(1000L))).apply((PTransform)ParDo.of((DoFn)new TestRow.DeterministicallyConstructTestRowFn()))).apply((PTransform)SingleStoreIO.write().withDataSourceConfiguration(dataSourceConfiguration).withTable("t").withUserDataMapper((SingleStoreIO.UserDataMapper)new TestHelper.TestUserDataMapper()).withBatchSize(Integer.valueOf(1000)));
        PAssert.thatSingleton((PCollection)((PCollection)rows.apply("Sum All", (PTransform)Sum.integersGlobally()))).isEqualTo((Object)1000);
        PAssert.that((PCollection)rows).satisfies((SerializableFunction)new BatchSizeChecker(1000));
        this.pipeline.run();
        this.checkRows();
    }

    @Test
    public void testWriteInvalidBatchSize() {
        Assert.assertThrows((String)"batchSize should be greater then 0", IllegalArgumentException.class, () -> {
            PCollection cfr_ignored_0 = (PCollection)((PCollection)((PCollection)this.pipelineForErrorChecks.apply((PTransform)GenerateSequence.from((long)0L).to(1000L))).apply((PTransform)ParDo.of((DoFn)new TestRow.DeterministicallyConstructTestRowFn()))).apply((PTransform)SingleStoreIO.write().withDataSourceConfiguration(dataSourceConfiguration).withTable("t").withUserDataMapper((SingleStoreIO.UserDataMapper)new TestHelper.TestUserDataMapper()).withBatchSize(Integer.valueOf(0)));
        });
    }

    static {
        writtenRows = Collections.synchronizedList(new ArrayList());
    }

    private static class BatchSizeChecker
    implements SerializableFunction<Iterable<Integer>, Void> {
        Integer maxBatchSize;

        BatchSizeChecker(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        public Void apply(Iterable<Integer> input) {
            for (Integer batchSize : input) {
                Assert.assertTrue((batchSize <= this.maxBatchSize ? 1 : 0) != 0);
            }
            return null;
        }
    }

    private static class GetDataSource
    implements Serializable,
    Answer<DataSource> {
        private GetDataSource() {
        }

        public DataSource answer(InvocationOnMock invocation) throws SQLException {
            Statement stmt = (Statement)Mockito.mock(Statement.class);
            SetInputStream inputStreamSetter = new SetInputStream();
            ((Statement)Mockito.doAnswer((Answer)inputStreamSetter).when((Object)stmt)).setNextLocalInfileInputStream((InputStream)Mockito.any());
            DelegatingStatement delStmt = (DelegatingStatement)Mockito.mock(DelegatingStatement.class);
            Mockito.when((Object)delStmt.getInnermostDelegate()).thenReturn((Object)stmt);
            ((DelegatingStatement)Mockito.doAnswer((Answer)new ExecuteUpdate(inputStreamSetter)).when((Object)delStmt)).executeUpdate("LOAD DATA LOCAL INFILE '###.tsv' INTO TABLE `t`");
            Connection conn = (Connection)Mockito.mock(Connection.class);
            Mockito.when((Object)conn.createStatement()).thenReturn((Object)delStmt);
            DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
            Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)conn);
            return dataSource;
        }
    }

    private static class ExecuteUpdate
    implements Serializable,
    Answer<Integer> {
        SetInputStream inputStreamSetter;

        ExecuteUpdate(SetInputStream inputStreamSetter) {
            this.inputStreamSetter = inputStreamSetter;
        }

        public Integer answer(InvocationOnMock invocation) {
            InputStream s = this.inputStreamSetter.getInputStream();
            StringBuilder csvBuilder = new StringBuilder();
            byte[] b = new byte[100];
            try {
                int len;
                while ((len = s.read(b)) != -1) {
                    for (int i = 0; i < len; ++i) {
                        csvBuilder.append((char)b[i]);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            List rows = Splitter.on((char)'\n').omitEmptyStrings().splitToList((CharSequence)csvBuilder.toString());
            for (String row : rows) {
                List values = Splitter.on((char)'\t').splitToList((CharSequence)row);
                Integer id = Integer.valueOf((String)values.get(0));
                String name = (String)values.get(1);
                writtenRows.add(TestRow.create((Integer)id, (String)name));
            }
            return rows.size();
        }
    }

    private static class SetInputStream
    implements Serializable,
    Answer<Void> {
        InputStream inputStream;

        private SetInputStream() {
        }

        public Void answer(InvocationOnMock invocation) {
            this.inputStream = (InputStream)invocation.getArgument(0, InputStream.class);
            return null;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

