/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.singlestore;

import com.singlestore.jdbc.SingleStoreDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.io.singlestore.SingleStoreIO;

public class TestHelper {
    public static void createDatabaseIfNotExists(String serverName, Integer port, String username, String password, String databaseName) throws SQLException {
        SingleStoreDataSource dataSource = new SingleStoreDataSource(String.format("jdbc:singlestore://%s:%d/?user=%s&password=%s&allowLocalInfile=TRUE", serverName, port, username, password));
        try (Connection conn = dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeQuery(String.format("CREATE DATABASE IF NOT EXISTS %s", databaseName));
        }
    }

    public static abstract class MockDataSourceConfiguration
    extends SingleStoreIO.DataSourceConfiguration {
        String getEndpoint() {
            return "localhost";
        }

        String getDatabase() {
            return "db";
        }

        String getConnectionProperties() {
            return "";
        }

        String getUsername() {
            return "admin";
        }

        String getPassword() {
            return "secretPass";
        }
    }

    public static class TestUserDataMapper
    implements SingleStoreIO.UserDataMapper<TestRow> {
        public List<String> mapRow(TestRow element) {
            ArrayList<String> res = new ArrayList<String>();
            res.add(element.id().toString());
            res.add(element.name());
            return res;
        }
    }

    public static class TestRowMapper
    implements SingleStoreIO.RowMapper<TestRow> {
        public TestRow mapRow(ResultSet resultSet) throws Exception {
            return TestRow.create((Integer)resultSet.getInt(1), (String)resultSet.getString(2));
        }
    }
}

