/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.singlestore;

import java.sql.ResultSet;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.io.singlestore.SingleStoreIO;
import org.apache.beam.sdk.io.singlestore.SingleStoreUtil;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class SingleStoreUtilTest {
    private static final Logger LOG = LoggerFactory.getLogger(SingleStoreUtilTest.class);

    @Test
    public void testEscapeIdentifierEmpty() {
        Assert.assertEquals((Object)"``", (Object)SingleStoreUtil.escapeIdentifier((String)""));
    }

    @Test
    public void testEscapeIdentifierNoSpecialCharacters() {
        Assert.assertEquals((Object)"`asdasd asd ad`", (Object)SingleStoreUtil.escapeIdentifier((String)"asdasd asd ad"));
    }

    @Test
    public void testEscapeIdentifierWithSpecialCharacters() {
        Assert.assertEquals((Object)"`a````sdasd`` asd`` ad```", (Object)SingleStoreUtil.escapeIdentifier((String)"a``sdasd` asd` ad`"));
    }

    @Test
    public void testEscapeStringEmpty() {
        Assert.assertEquals((Object)"''", (Object)SingleStoreUtil.escapeString((String)""));
    }

    @Test
    public void testEscapeStringNoSpecialCharacters() {
        Assert.assertEquals((Object)"'asdasd asd ad'", (Object)SingleStoreUtil.escapeString((String)"asdasd asd ad"));
    }

    @Test
    public void testEscapeStringWithSpecialCharacters() {
        Assert.assertEquals((Object)"'a\\'\\'sdasd\\' \\\\asd\\' \\\\ad\\''", (Object)SingleStoreUtil.escapeString((String)"a''sdasd' \\asd' \\ad'"));
    }

    @Test
    public void testInferCoderFromRowMapper() {
        SchemaRegistry sr = SchemaRegistry.createDefault();
        CoderRegistry cr = CoderRegistry.createDefault();
        SerializableCoder c = SerializableCoder.of(TestRow.class);
        Assert.assertEquals((Object)c, (Object)SingleStoreUtil.inferCoder((SingleStoreIO.RowMapper)new TestRowMapperWithCoder(), (CoderRegistry)cr, (SchemaRegistry)sr, (Logger)LOG));
    }

    @Test
    public void testInferCoderFromSchemaRegistry() {
        SchemaRegistry sr = SchemaRegistry.createDefault();
        CoderRegistry cr = CoderRegistry.createDefault();
        SerializableCoder c = SerializableCoder.of(TestRow.class);
        cr.registerCoderForClass(TestRow.class, (Coder)c);
        Assert.assertEquals((Object)c, (Object)SingleStoreUtil.inferCoder((SingleStoreIO.RowMapper)new TestRowMapper(), (CoderRegistry)cr, (SchemaRegistry)sr, (Logger)LOG));
    }

    @Test
    public void testInferCoderFromCoderRegistry() throws NoSuchSchemaException {
        SchemaRegistry sr = SchemaRegistry.createDefault();
        CoderRegistry cr = CoderRegistry.createDefault();
        sr.registerPOJO(TestRow.class);
        SchemaCoder c = sr.getSchemaCoder(TestRow.class);
        Assert.assertEquals((Object)c, (Object)SingleStoreUtil.inferCoder((SingleStoreIO.RowMapper)new TestRowMapper(), (CoderRegistry)cr, (SchemaRegistry)sr, (Logger)LOG));
    }

    @Test
    public void testGetSelectQueryAllNulls() {
        String errorMessage = "One of withTable() or withQuery() is required";
        Assert.assertThrows((String)errorMessage, IllegalArgumentException.class, () -> SingleStoreUtil.getSelectQuery(null, null));
        Assert.assertThrows((String)errorMessage, IllegalArgumentException.class, () -> SingleStoreUtil.getSelectQuery(null, null));
    }

    @Test
    public void testGetSelectQueryNonNullQuery() {
        Assert.assertEquals((Object)"SELECT * FROM table", (Object)SingleStoreUtil.getSelectQuery(null, (String)"SELECT * FROM table"));
    }

    @Test
    public void testGetSelectQueryNonNullTable() {
        Assert.assertEquals((Object)"SELECT * FROM `ta``ble`", (Object)SingleStoreUtil.getSelectQuery((String)"ta`ble", null));
    }

    @Test
    public void testGetSelectQueryBothNonNulls() {
        Assert.assertThrows((String)"withTable() can not be used together with withQuery()", IllegalArgumentException.class, () -> SingleStoreUtil.getSelectQuery((String)"table", (String)"SELECT * FROM table"));
    }

    @Test
    public void testGetArgumentWithDefaultReturnsDefault() {
        Assert.assertEquals((Object)"default", (Object)SingleStoreUtil.getArgumentWithDefault(null, (Object)"default"));
    }

    @Test
    public void testGetArgumentWithDefault() {
        Assert.assertEquals((Object)"value", (Object)SingleStoreUtil.getArgumentWithDefault((Object)"value", (Object)"default"));
    }

    @Test
    public void testGetClassNameOrNullNull() {
        Assert.assertNull((Object)SingleStoreUtil.getClassNameOrNull(null));
    }

    @Test
    public void testGetClassNameOrNullClassName() {
        Assert.assertEquals((Object)"java.lang.String", (Object)SingleStoreUtil.getClassNameOrNull((Object)"asd"));
    }

    private static class TestRowMapperWithCoder
    extends TestRowMapper
    implements SingleStoreIO.RowMapperWithCoder<TestRow> {
        private TestRowMapperWithCoder() {
        }

        public Coder<TestRow> getCoder() throws Exception {
            return SerializableCoder.of(TestRow.class);
        }
    }

    private static class TestRowMapper
    implements SingleStoreIO.RowMapper<TestRow> {
        private TestRowMapper() {
        }

        public TestRow mapRow(ResultSet resultSet) throws Exception {
            return TestRow.create((Integer)resultSet.getInt(1), (String)resultSet.getString(2));
        }
    }
}

