/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.singlestore;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.common.DatabaseTestHelper;
import org.apache.beam.sdk.io.common.IOITHelper;
import org.apache.beam.sdk.io.singlestore.SingleStoreIO;
import org.apache.beam.sdk.io.singlestore.SingleStoreIOTestPipelineOptions;
import org.apache.beam.sdk.io.singlestore.TestHelper;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SingleStoreIODefaultMapperIT {
    private static final String DATABASE_NAME = "SingleStoreIOIT";
    private static int numberOfRows;
    private static String tableName;
    private static String serverName;
    private static String username;
    private static String password;
    private static Integer port;
    private static SingleStoreIO.DataSourceConfiguration dataSourceConfiguration;
    private static Schema schema;
    @Rule
    public TestPipeline pipelineWrite = TestPipeline.create();
    @Rule
    public TestPipeline pipelineRead = TestPipeline.create();

    @BeforeClass
    public static void setup() {
        SingleStoreIOTestPipelineOptions options;
        try {
            options = (SingleStoreIOTestPipelineOptions)IOITHelper.readIOTestPipelineOptions(SingleStoreIOTestPipelineOptions.class);
        }
        catch (IllegalArgumentException e) {
            options = null;
        }
        Assume.assumeNotNull((Object[])new Object[]{options});
        numberOfRows = options.getNumberOfRecords();
        serverName = options.getSingleStoreServerName();
        username = options.getSingleStoreUsername();
        password = options.getSingleStorePassword();
        port = options.getSingleStorePort();
        tableName = DatabaseTestHelper.getTestTableName((String)"IT");
        dataSourceConfiguration = SingleStoreIO.DataSourceConfiguration.create((String)(serverName + ":" + port)).withDatabase(DATABASE_NAME).withPassword(password).withUsername(username);
        SingleStoreIODefaultMapperIT.generateSchema();
    }

    private static void generateSchema() {
        Schema.Builder schemaBuilder = new Schema.Builder();
        schemaBuilder.addField("c1", Schema.FieldType.BOOLEAN);
        schemaBuilder.addField("c2", Schema.FieldType.BYTE);
        schemaBuilder.addField("c3", Schema.FieldType.INT16);
        schemaBuilder.addField("c4", Schema.FieldType.INT32);
        schemaBuilder.addField("c5", Schema.FieldType.INT64);
        schemaBuilder.addField("c6", Schema.FieldType.FLOAT);
        schemaBuilder.addField("c7", Schema.FieldType.DOUBLE);
        schemaBuilder.addField("c8", Schema.FieldType.DECIMAL);
        schemaBuilder.addField("c9", Schema.FieldType.DATETIME);
        schemaBuilder.addField("c10", Schema.FieldType.DATETIME);
        schemaBuilder.addField("c11", Schema.FieldType.DATETIME);
        schemaBuilder.addField("c12", Schema.FieldType.BYTES);
        schemaBuilder.addField("c13", Schema.FieldType.BYTES);
        schemaBuilder.addField("c14", Schema.FieldType.BYTES);
        schemaBuilder.addField("c15", Schema.FieldType.STRING);
        schemaBuilder.addField("c16", Schema.FieldType.STRING);
        schemaBuilder.addField("c17", Schema.FieldType.STRING);
        schema = schemaBuilder.build();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testWriteThenRead() throws Exception {
        TestHelper.createDatabaseIfNotExists(serverName, port, username, password, DATABASE_NAME);
        this.createTable();
        try {
            PipelineResult writeResult = this.runWrite();
            Assert.assertEquals((Object)PipelineResult.State.DONE, (Object)writeResult.waitUntilFinish());
            PipelineResult readResult = this.runRead();
            Assert.assertEquals((Object)PipelineResult.State.DONE, (Object)readResult.waitUntilFinish());
        }
        finally {
            DataSource dataSource = dataSourceConfiguration.getDataSource();
            DatabaseTestHelper.deleteTable((DataSource)dataSource, (String)tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable() throws SQLException {
        DataSource dataSource = dataSourceConfiguration.getDataSource();
        try (Connection conn = dataSource.getConnection();){
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("DROP TABLE IF EXISTS " + tableName);
            stmt.executeUpdate("CREATE TABLE " + tableName + "(c1 BIT, c2 TINYINT, c3 SMALLINT, c4 INTEGER, c5 BIGINT, c6 FLOAT, c7 DOUBLE, c8 DECIMAL(10, 5), c9 TIMESTAMP, c10 DATE, c11 TIME, c12 BLOB, c13 TINYBLOB, c14 BINARY(10), c15 MEDIUMTEXT, c16 TINYTEXT, c17 CHAR(10) )");
        }
    }

    private PipelineResult runWrite() {
        ((PCollection)((PCollection)this.pipelineWrite.apply((PTransform)GenerateSequence.from((long)0L).to((long)numberOfRows))).apply((PTransform)ParDo.of((DoFn)new ConstructRowFn()))).setRowSchema(schema).apply((PTransform)SingleStoreIO.writeRows().withDataSourceConfiguration(dataSourceConfiguration).withTable(tableName));
        return this.pipelineWrite.run();
    }

    private PipelineResult runRead() {
        PCollection res = (PCollection)this.pipelineRead.apply((PTransform)SingleStoreIO.readRows().withDataSourceConfiguration(dataSourceConfiguration).withTable(tableName));
        PAssert.thatSingleton((PCollection)((PCollection)res.apply("Count All", Count.globally()))).isEqualTo((Object)numberOfRows);
        ((PCollection)res.apply((PTransform)ParDo.of((DoFn)new CheckDoFn()))).setCoder((Coder)VoidCoder.of());
        return this.pipelineRead.run();
    }

    private static class CheckDoFn
    extends DoFn<Row, Void> {
        private CheckDoFn() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c) {
            Row r = (Row)c.element();
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((Object)Boolean.TRUE, (Object)r.getBoolean(0));
            Assert.assertEquals((Object)10, (Object)r.getByte(1));
            Assert.assertEquals((Object)10, (Object)r.getInt16(2));
            Assert.assertEquals((Object)10, (Object)r.getInt32(3));
            Assert.assertEquals((Object)10L, (Object)r.getInt64(4));
            Assert.assertEquals((Object)Float.valueOf(10.1f), (Object)r.getFloat(5));
            Assert.assertEquals((Object)10.1, (Object)r.getDouble(6));
            Assert.assertEquals((Object)new BigDecimal("10.10000"), (Object)r.getDecimal(7));
            Assert.assertEquals((long)0L, (long)new DateTime((Object)"2022-01-01T10:10:10Z").compareTo((ReadableInstant)r.getDateTime(8)));
            Assert.assertEquals((long)0L, (long)new DateTime((Object)"2022-01-01T00:00:00Z").compareTo((ReadableInstant)r.getDateTime(9)));
            Assert.assertEquals((long)0L, (long)new DateTime((Object)"1970-01-01T10:10:10Z").compareTo((ReadableInstant)r.getDateTime(10)));
            Assert.assertArrayEquals((byte[])"asd".getBytes(StandardCharsets.UTF_8), (byte[])r.getBytes(11));
            Assert.assertArrayEquals((byte[])"asd".getBytes(StandardCharsets.UTF_8), (byte[])r.getBytes(12));
            Assert.assertArrayEquals((byte[])"asd\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes(StandardCharsets.UTF_8), (byte[])r.getBytes(13));
            Assert.assertEquals((Object)"asd", (Object)r.getString(14));
            Assert.assertEquals((Object)"asd", (Object)r.getString(15));
            Assert.assertEquals((Object)"asd", (Object)r.getString(16));
        }
    }

    public static class ConstructRowFn
    extends DoFn<Long, Row> {
        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Row.Builder rowBuilder = Row.withSchema((Schema)schema);
            rowBuilder.addValue((Object)Boolean.TRUE);
            rowBuilder.addValue((Object)10);
            rowBuilder.addValue((Object)10);
            rowBuilder.addValue((Object)10);
            rowBuilder.addValue((Object)10L);
            rowBuilder.addValue((Object)Float.valueOf(10.1f));
            rowBuilder.addValue((Object)10.1);
            rowBuilder.addValue((Object)new BigDecimal("10.1"));
            rowBuilder.addValue((Object)new DateTime((Object)"2022-01-01T10:10:10Z"));
            rowBuilder.addValue((Object)new DateTime((Object)"2022-01-01T10:10:10Z"));
            rowBuilder.addValue((Object)new DateTime((Object)"2022-01-01T10:10:10Z"));
            rowBuilder.addValue((Object)"asd".getBytes(StandardCharsets.UTF_8));
            rowBuilder.addValue((Object)"asd".getBytes(StandardCharsets.UTF_8));
            rowBuilder.addValue((Object)"asd".getBytes(StandardCharsets.UTF_8));
            rowBuilder.addValue((Object)"asd");
            rowBuilder.addValue((Object)"asd");
            rowBuilder.addValue((Object)"asd");
            Row row = rowBuilder.build();
            c.output((Object)row);
        }
    }
}

