/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.singlestore;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.beam.sdk.io.singlestore.SingleStoreDefaultUserDataMapper;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SingleStoreDefaultUserDataMapperTest {
    @Test
    public void testNullValues() {
    }

    @Test
    public void testBigNumbers() {
    }

    @Test
    public void testBigNegativeNumbers() {
        Schema.Builder schemaBuilder = new Schema.Builder();
        schemaBuilder.addField("byte", Schema.FieldType.BYTE);
        schemaBuilder.addField("int16", Schema.FieldType.INT16);
        schemaBuilder.addField("int32", Schema.FieldType.INT32);
        schemaBuilder.addField("int64", Schema.FieldType.INT64);
        schemaBuilder.addField("float", Schema.FieldType.FLOAT);
        schemaBuilder.addField("double", Schema.FieldType.DOUBLE);
        schemaBuilder.addField("decimal", Schema.FieldType.DECIMAL);
        Schema schema = schemaBuilder.build();
        Row.Builder rowBuilder = Row.withSchema((Schema)schema);
        rowBuilder.addValue((Object)-128);
        rowBuilder.addValue((Object)Short.MIN_VALUE);
        rowBuilder.addValue((Object)Integer.MIN_VALUE);
        rowBuilder.addValue((Object)Long.MIN_VALUE);
        rowBuilder.addValue((Object)Float.valueOf(-3.4028235E38f));
        rowBuilder.addValue((Object)-1.7976931348623157E308);
        rowBuilder.addValue((Object)new BigDecimal("-10000000000000.1000000000000000000000"));
        Row row = rowBuilder.build();
        SingleStoreDefaultUserDataMapper mapper = new SingleStoreDefaultUserDataMapper();
        List res = mapper.mapRow(row);
        Assert.assertEquals((long)7L, (long)res.size());
        Assert.assertEquals((Object)"-128", res.get(0));
        Assert.assertEquals((Object)"-32768", res.get(1));
        Assert.assertEquals((Object)"-2147483648", res.get(2));
        Assert.assertEquals((Object)"-9223372036854775808", res.get(3));
        Assert.assertEquals((Object)"-3.4028235E38", res.get(4));
        Assert.assertEquals((Object)"-1.7976931348623157E308", res.get(5));
        Assert.assertEquals((Object)"-10000000000000.1000000000000000000000", res.get(6));
    }

    @Test
    public void testEmptyRow() {
        Schema.Builder schemaBuilder = new Schema.Builder();
        Schema schema = schemaBuilder.build();
        Row.Builder rowBuilder = Row.withSchema((Schema)schema);
        Row row = rowBuilder.build();
        SingleStoreDefaultUserDataMapper mapper = new SingleStoreDefaultUserDataMapper();
        List res = mapper.mapRow(row);
        Assert.assertEquals((long)0L, (long)res.size());
    }

    @Test
    public void testAllDataTypes() {
        Schema.Builder schemaBuilder = new Schema.Builder();
        schemaBuilder.addField("byte", Schema.FieldType.BYTE);
        schemaBuilder.addField("int16", Schema.FieldType.INT16);
        schemaBuilder.addField("int32", Schema.FieldType.INT32);
        schemaBuilder.addField("int64", Schema.FieldType.INT64);
        schemaBuilder.addField("float", Schema.FieldType.FLOAT);
        schemaBuilder.addField("double", Schema.FieldType.DOUBLE);
        schemaBuilder.addField("decimal", Schema.FieldType.DECIMAL);
        schemaBuilder.addField("boolean", Schema.FieldType.BOOLEAN);
        schemaBuilder.addField("datetime", Schema.FieldType.DATETIME);
        schemaBuilder.addField("bytes", Schema.FieldType.BYTES);
        schemaBuilder.addField("string", Schema.FieldType.STRING);
        Schema schema = schemaBuilder.build();
        Row.Builder rowBuilder = Row.withSchema((Schema)schema);
        rowBuilder.addValue((Object)10);
        rowBuilder.addValue((Object)10);
        rowBuilder.addValue((Object)10);
        rowBuilder.addValue((Object)10L);
        rowBuilder.addValue((Object)Float.valueOf(10.1f));
        rowBuilder.addValue((Object)10.1);
        rowBuilder.addValue((Object)new BigDecimal("10.1"));
        rowBuilder.addValue((Object)false);
        rowBuilder.addValue((Object)new DateTime((Object)"2022-01-01T10:10:10.012Z"));
        rowBuilder.addValue((Object)"asd".getBytes(StandardCharsets.UTF_8));
        rowBuilder.addValue((Object)"asd");
        Row row = rowBuilder.build();
        SingleStoreDefaultUserDataMapper mapper = new SingleStoreDefaultUserDataMapper();
        List res = mapper.mapRow(row);
        Assert.assertEquals((long)11L, (long)res.size());
        Assert.assertEquals((Object)"10", res.get(0));
        Assert.assertEquals((Object)"10", res.get(1));
        Assert.assertEquals((Object)"10", res.get(2));
        Assert.assertEquals((Object)"10", res.get(3));
        Assert.assertEquals((Object)"10.1", res.get(4));
        Assert.assertEquals((Object)"10.1", res.get(5));
        Assert.assertEquals((Object)"10.1", res.get(6));
        Assert.assertEquals((Object)"0", res.get(7));
        Assert.assertEquals((Object)"2022-01-01 10:10:10.012", res.get(8));
        Assert.assertEquals((Object)"asd", res.get(9));
        Assert.assertEquals((Object)"asd", res.get(10));
    }
}

